/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.inject.Inject;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.sql.calcite.table.DatasourceTable;

public class PhysicalDatasourceMetadataFactory {
    private final JoinableFactory joinableFactory;
    private final SegmentManager segmentManager;

    @Inject
    public PhysicalDatasourceMetadataFactory(JoinableFactory joinableFactory, SegmentManager segmentManager) {
        this.joinableFactory = joinableFactory;
        this.segmentManager = segmentManager;
    }

    DatasourceTable.PhysicalDatasourceMetadata build(String dataSource, RowSignature rowSignature) {
        GlobalTableDataSource maybeGlobal = new GlobalTableDataSource(dataSource);
        boolean isJoinable = this.joinableFactory.isDirectlyJoinable((DataSource)maybeGlobal);
        boolean isBroadcast = this.segmentManager.getDataSourceNames().contains(dataSource);
        Object tableDataSource = isBroadcast && isJoinable ? maybeGlobal : new TableDataSource(dataSource);
        return new DatasourceTable.PhysicalDatasourceMetadata((TableDataSource)tableDataSource, rowSignature, isJoinable, isBroadcast);
    }
}

