/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.table;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeComparability;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.AbstractSqlType;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.serde.ComplexMetricSerde;
import org.apache.druid.segment.serde.ComplexMetrics;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.planner.Calcites;

public class RowSignatures {
    private RowSignatures() {
    }

    public static RowSignature fromRelDataType(List<String> rowOrder, RelDataType rowType) {
        if (rowOrder.size() != rowType.getFieldCount()) {
            throw new IAE("Field count %d != %d", new Object[]{rowOrder.size(), rowType.getFieldCount()});
        }
        RowSignature.Builder rowSignatureBuilder = RowSignature.builder();
        for (int i = 0; i < rowOrder.size(); ++i) {
            RelDataType dataType = ((RelDataTypeField)rowType.getFieldList().get(i)).getType();
            ColumnType valueType = Calcites.getColumnTypeForRelDataType(dataType);
            rowSignatureBuilder.add(rowOrder.get(i), valueType);
        }
        return rowSignatureBuilder.build();
    }

    @Nonnull
    public static StringComparator getNaturalStringComparator(RowSignature rowSignature, SimpleExtraction simpleExtraction) {
        Preconditions.checkNotNull((Object)simpleExtraction, (Object)"simpleExtraction");
        if (simpleExtraction.getExtractionFn() != null || rowSignature.getColumnType(simpleExtraction.getColumn()).map(type -> type.is((TypeDescriptor)ValueType.STRING)).orElse(false).booleanValue()) {
            return StringComparators.LEXICOGRAPHIC;
        }
        return StringComparators.NUMERIC;
    }

    public static RelDataType toRelDataType(RowSignature rowSignature, RelDataTypeFactory typeFactory) {
        return RowSignatures.toRelDataType(rowSignature, typeFactory, true);
    }

    public static RelDataType toRelDataType(RowSignature rowSignature, RelDataTypeFactory typeFactory, boolean typecastTimeColumn) {
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        boolean nullNumeric = !NullHandling.replaceWithDefault();
        for (String columnName : rowSignature.getColumnNames()) {
            RelDataType type;
            if (typecastTimeColumn && "__time".equals(columnName)) {
                type = Calcites.createSqlType(typeFactory, SqlTypeName.TIMESTAMP);
            } else {
                ColumnType columnType = (ColumnType)rowSignature.getColumnType(columnName).orElseThrow(() -> new ISE("Encountered null type for column[%s]", new Object[]{columnName}));
                type = RowSignatures.columnTypeToRelDataType(typeFactory, columnType, nullNumeric);
            }
            builder.add(columnName, type);
        }
        return builder.build();
    }

    public static RelDataType columnTypeToRelDataType(RelDataTypeFactory typeFactory, ColumnType columnType, boolean nullNumeric) {
        RelDataType type;
        switch ((ValueType)columnType.getType()) {
            case STRING: {
                type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.VARCHAR, true);
                break;
            }
            case LONG: {
                type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.BIGINT, nullNumeric);
                break;
            }
            case FLOAT: {
                type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.FLOAT, nullNumeric);
                break;
            }
            case DOUBLE: {
                type = Calcites.createSqlTypeWithNullability(typeFactory, SqlTypeName.DOUBLE, nullNumeric);
                break;
            }
            case ARRAY: {
                RelDataType elementType = RowSignatures.columnTypeToRelDataType(typeFactory, (ColumnType)columnType.getElementType(), nullNumeric);
                type = typeFactory.createTypeWithNullability(typeFactory.createArrayType(elementType, -1L), true);
                break;
            }
            case COMPLEX: {
                type = RowSignatures.makeComplexType(typeFactory, columnType, true);
                break;
            }
            default: {
                throw new ISE("valueType[%s] not translatable", new Object[]{columnType});
            }
        }
        return type;
    }

    public static RelDataType makeComplexType(RelDataTypeFactory typeFactory, ColumnType columnType, boolean isNullable) {
        return typeFactory.createTypeWithNullability((RelDataType)new ComplexSqlType(SqlTypeName.OTHER, columnType, isNullable), isNullable);
    }

    public static ComplexSqlSingleOperandTypeChecker complexTypeChecker(ColumnType complexType) {
        return new ComplexSqlSingleOperandTypeChecker(new ComplexSqlType(SqlTypeName.OTHER, complexType, true));
    }

    public static final class ComplexSqlSingleOperandTypeChecker
    implements SqlSingleOperandTypeChecker {
        private final ComplexSqlType type;

        public ComplexSqlSingleOperandTypeChecker(ComplexSqlType type) {
            this.type = type;
        }

        public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, boolean throwOnFailure) {
            return this.type.equals(callBinding.getValidator().deriveType(callBinding.getScope(), operand));
        }

        public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
            if (callBinding.getOperandCount() != 1) {
                return false;
            }
            return this.checkSingleOperandType(callBinding, callBinding.operand(0), 0, throwOnFailure);
        }

        public SqlOperandCountRange getOperandCountRange() {
            return SqlOperandCountRanges.of((int)1);
        }

        public String getAllowedSignatures(SqlOperator op, String opName) {
            return StringUtils.format((String)"'%s'(%s)", (Object[])new Object[]{opName, this.type});
        }

        public SqlOperandTypeChecker.Consistency getConsistency() {
            return SqlOperandTypeChecker.Consistency.NONE;
        }

        public boolean isOptional(int i) {
            return false;
        }
    }

    public static final class ComplexSqlType
    extends AbstractSqlType {
        private final ColumnType columnType;

        public ComplexSqlType(SqlTypeName typeName, ColumnType columnType, boolean isNullable) {
            super(typeName, isNullable, null);
            ComplexMetricSerde serde = columnType.getComplexTypeName() != null ? ComplexMetrics.getSerdeForType((String)columnType.getComplexTypeName()) : null;
            this.columnType = serde != null ? ColumnType.ofComplex((String)serde.getTypeName()) : columnType;
            this.computeDigest();
        }

        public RelDataTypeComparability getComparability() {
            return RelDataTypeComparability.UNORDERED;
        }

        protected void generateTypeString(StringBuilder sb, boolean withDetail) {
            sb.append(this.columnType.asTypeString());
        }

        public ColumnType getColumnType() {
            return this.columnType;
        }

        public String getComplexTypeName() {
            return this.columnType.getComplexTypeName();
        }

        public String asTypeString() {
            return this.columnType.asTypeString();
        }
    }
}

