/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;
import java.util.Objects;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.QueryCounterSnapshot;

public class CounterSnapshots {
    private final Map<String, QueryCounterSnapshot> snapshotMap;

    @JsonCreator
    public CounterSnapshots(Map<String, QueryCounterSnapshot> snapshotMap) {
        this.snapshotMap = ImmutableSortedMap.copyOf(snapshotMap, CounterNames.comparator());
    }

    public Map<String, QueryCounterSnapshot> getMap() {
        return this.snapshotMap;
    }

    public boolean isEmpty() {
        return this.snapshotMap.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterSnapshots that = (CounterSnapshots)o;
        return Objects.equals(this.snapshotMap, that.snapshotMap);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotMap);
    }

    public String toString() {
        return this.snapshotMap.toString();
    }
}

