/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.counters;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.msq.counters.CpuCounter;
import org.apache.druid.msq.counters.QueryCounter;
import org.apache.druid.msq.counters.QueryCounterSnapshot;

public class CpuCounters
implements QueryCounter {
    public static final String LABEL_MAIN = "main";
    public static final String LABEL_KEY_STATISTICS = "collectKeyStatistics";
    public static final String LABEL_MERGE_INPUT = "mergeInput";
    public static final String LABEL_HASH_PARTITION = "hashPartitionOutput";
    public static final String LABEL_MIX = "mixOutput";
    public static final String LABEL_SORT = "sortOutput";
    private final ConcurrentHashMap<String, CpuCounter> counters = new ConcurrentHashMap();

    public CpuCounter forName(String name) {
        return this.counters.computeIfAbsent(name, k -> new CpuCounter());
    }

    @Override
    @Nullable
    public Snapshot snapshot() {
        HashMap<String, CpuCounter.Snapshot> snapshotMap = new HashMap<String, CpuCounter.Snapshot>();
        for (Map.Entry<String, CpuCounter> entry : this.counters.entrySet()) {
            snapshotMap.put(entry.getKey(), entry.getValue().snapshot());
        }
        return new Snapshot(snapshotMap);
    }

    @JsonTypeName(value="cpus")
    public static class Snapshot
    implements QueryCounterSnapshot {
        private final Map<String, CpuCounter.Snapshot> map;

        @JsonCreator
        public Snapshot(Map<String, CpuCounter.Snapshot> map) {
            this.map = (Map)Preconditions.checkNotNull(map, (Object)"map");
        }

        @JsonValue
        public Map<String, CpuCounter.Snapshot> getCountersMap() {
            return this.map;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snapshot snapshot = (Snapshot)o;
            return Objects.equals(this.map, snapshot.map);
        }

        public int hashCode() {
            return Objects.hash(this.map);
        }

        public String toString() {
            return "CpuCounters.Snapshot{map=" + this.map + '}';
        }
    }
}

