/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.kernel.StageId;

public class DoneReadingInput
implements ControllerMessage {
    private final StageId stageId;
    private final int workerNumber;

    @JsonCreator
    public DoneReadingInput(@JsonProperty(value="stage") StageId stageId, @JsonProperty(value="worker") int workerNumber) {
        this.stageId = (StageId)Preconditions.checkNotNull((Object)stageId, (Object)"stageId");
        this.workerNumber = workerNumber;
    }

    @Override
    public String getQueryId() {
        return this.stageId.getQueryId();
    }

    @JsonProperty(value="stage")
    public StageId getStageId() {
        return this.stageId;
    }

    @JsonProperty(value="worker")
    public int getWorkerNumber() {
        return this.workerNumber;
    }

    @Override
    public void handle(Controller controller) {
        controller.doneReadingInput(this.stageId.getStageNumber(), this.workerNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoneReadingInput that = (DoneReadingInput)o;
        return this.workerNumber == that.workerNumber && Objects.equals(this.stageId, that.stageId);
    }

    public int hashCode() {
        return Objects.hash(this.stageId, this.workerNumber);
    }

    public String toString() {
        return "DoneReadingInput{stageId=" + this.stageId + ", workerNumber=" + this.workerNumber + '}';
    }
}

