/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.kernel.StageId;

public class ResultsComplete
implements ControllerMessage {
    private final StageId stageId;
    private final int workerNumber;
    @Nullable
    private final Object resultObject;

    @JsonCreator
    public ResultsComplete(@JsonProperty(value="stage") StageId stageId, @JsonProperty(value="worker") int workerNumber, @Nullable @JsonProperty(value="result") Object resultObject) {
        this.stageId = (StageId)Preconditions.checkNotNull((Object)stageId, (Object)"stageId");
        this.workerNumber = workerNumber;
        this.resultObject = resultObject;
    }

    @Override
    public String getQueryId() {
        return this.stageId.getQueryId();
    }

    @JsonProperty(value="stage")
    public StageId getStageId() {
        return this.stageId;
    }

    @JsonProperty(value="worker")
    public int getWorkerNumber() {
        return this.workerNumber;
    }

    @Nullable
    @JsonProperty(value="result")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getResultObject() {
        return this.resultObject;
    }

    @Override
    public void handle(Controller controller) {
        controller.resultsComplete(this.stageId.getQueryId(), this.stageId.getStageNumber(), this.workerNumber, this.resultObject);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultsComplete that = (ResultsComplete)o;
        return this.workerNumber == that.workerNumber && Objects.equals(this.stageId, that.stageId) && Objects.equals(this.resultObject, that.resultObject);
    }

    public int hashCode() {
        return Objects.hash(this.stageId, this.workerNumber, this.resultObject);
    }

    public String toString() {
        return "ResultsComplete{stageId=" + this.stageId + ", workerNumber=" + this.workerNumber + ", resultObject=" + this.resultObject + '}';
    }
}

