/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class DartQueryableSegment {
    private final DataSegment segment;
    private final Interval interval;
    private final int workerNumber;

    public DartQueryableSegment(DataSegment segment, Interval interval, int workerNumber) {
        this.segment = (DataSegment)Preconditions.checkNotNull((Object)segment, (Object)"segment");
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.workerNumber = workerNumber;
    }

    public DataSegment getSegment() {
        return this.segment;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public int getWorkerNumber() {
        return this.workerNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DartQueryableSegment that = (DartQueryableSegment)o;
        return this.workerNumber == that.workerNumber && Objects.equals(this.segment, that.segment) && Objects.equals(this.interval, that.interval);
    }

    public int hashCode() {
        return Objects.hash(this.segment, this.interval, this.workerNumber);
    }

    public String toString() {
        return "QueryableDataSegment{segment=" + this.segment + ", interval=" + this.interval + ", workerNumber=" + this.workerNumber + '}';
    }
}

