/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.QueryListener;
import org.apache.druid.msq.exec.ResultsContext;
import org.apache.druid.msq.indexing.report.MSQResultsReport;
import org.apache.druid.msq.util.SqlStatementResourceHelper;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.ColumnMapping;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.utils.CloseableUtils;

public class ControllerQueryResultsReader
implements FrameProcessor<Void> {
    private static final Logger log = new Logger(ControllerQueryResultsReader.class);
    private final ReadableFrameChannel in;
    private final FrameReader frameReader;
    private final ColumnMappings columnMappings;
    private final ResultsContext resultsContext;
    private final ObjectMapper jsonMapper;
    private final QueryListener queryListener;
    private boolean wroteResultsStart;

    ControllerQueryResultsReader(ReadableFrameChannel in, FrameReader frameReader, ColumnMappings columnMappings, ResultsContext resultsContext, ObjectMapper jsonMapper, QueryListener queryListener) {
        this.in = in;
        this.frameReader = frameReader;
        this.columnMappings = columnMappings;
        this.resultsContext = resultsContext;
        this.jsonMapper = jsonMapper;
        this.queryListener = queryListener;
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.in);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReturnOrAwait<Void> runIncrementally(IntSet readableInputs) {
        if (readableInputs.isEmpty()) {
            return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
        }
        if (!this.wroteResultsStart) {
            RowSignature querySignature = this.frameReader.signature();
            ImmutableList.Builder mappedSignature = ImmutableList.builder();
            for (ColumnMapping mapping : this.columnMappings.getMappings()) {
                mappedSignature.add((Object)new MSQResultsReport.ColumnAndType(mapping.getOutputColumn(), querySignature.getColumnType(mapping.getQueryColumn()).orElse(null)));
            }
            this.queryListener.onResultsStart((List<MSQResultsReport.ColumnAndType>)mappedSignature.build(), this.resultsContext.getSqlTypeNames());
            this.wroteResultsStart = true;
        }
        if (this.in.isFinished()) {
            this.queryListener.onResultsComplete();
            return ReturnOrAwait.returnObject(null);
        }
        Frame frame = this.in.read();
        Yielder rowYielder = Yielders.each(SqlStatementResourceHelper.getResultSequence(frame, this.frameReader, this.columnMappings, this.resultsContext, this.jsonMapper));
        try {
            while (!rowYielder.isDone()) {
                if (this.queryListener.onResultRow((Object[])rowYielder.get())) {
                    rowYielder = rowYielder.next(null);
                    continue;
                }
                ReturnOrAwait returnOrAwait = ReturnOrAwait.returnObject(null);
                return returnOrAwait;
            }
        }
        finally {
            CloseableUtils.closeAndSuppressExceptions((Closeable)rowYielder, e -> log.warn(e, "Failed to close frame yielder", new Object[0]));
        }
        return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[0]);
    }
}

