/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;

public class MemoryIntrospectorImpl
implements MemoryIntrospector {
    private static final Logger log = new Logger(MemoryIntrospectorImpl.class);
    private static final long LOOKUP_FOOTPRINT_INIT = Long.MIN_VALUE;
    private final long totalMemoryInJvm;
    private final double usableMemoryFraction;
    private final int numTasksInJvm;
    private final int numProcessingThreads;
    private volatile long lookupFootprint = Long.MIN_VALUE;
    @Nullable
    private final LookupExtractorFactoryContainerProvider lookupProvider;

    public MemoryIntrospectorImpl(long totalMemoryInJvm, double usableMemoryFraction, int numTasksInJvm, int numProcessingThreads, @Nullable LookupExtractorFactoryContainerProvider lookupProvider) {
        this.totalMemoryInJvm = totalMemoryInJvm;
        this.usableMemoryFraction = usableMemoryFraction;
        this.numTasksInJvm = numTasksInJvm;
        this.numProcessingThreads = numProcessingThreads;
        this.lookupProvider = lookupProvider;
    }

    @Override
    public long totalMemoryInJvm() {
        return this.totalMemoryInJvm;
    }

    @Override
    public long memoryPerTask() {
        return Math.max(0L, (long)((double)(this.totalMemoryInJvm - this.getTotalLookupFootprint()) * this.usableMemoryFraction) / (long)this.numTasksInJvm);
    }

    @Override
    public long computeJvmMemoryRequiredForTaskMemory(long memoryPerTask) {
        if (memoryPerTask <= 0L) {
            throw new IAE("Invalid memoryPerTask[%d], expected a positive number", new Object[]{memoryPerTask});
        }
        return (long)Math.ceil((double)(memoryPerTask * (long)this.numTasksInJvm) / this.usableMemoryFraction) + this.getTotalLookupFootprint();
    }

    @Override
    public int numTasksInJvm() {
        return this.numTasksInJvm;
    }

    @Override
    public int numProcessingThreads() {
        return this.numProcessingThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTotalLookupFootprint() {
        if (this.lookupFootprint == Long.MIN_VALUE) {
            MemoryIntrospectorImpl memoryIntrospectorImpl = this;
            synchronized (memoryIntrospectorImpl) {
                if (this.lookupFootprint == Long.MIN_VALUE) {
                    this.lookupFootprint = this.computeTotalLookupFootprint();
                }
            }
        }
        return this.lookupFootprint;
    }

    private long computeTotalLookupFootprint() {
        if (this.lookupProvider == null) {
            return 0L;
        }
        ImmutableList lookupNames = ImmutableList.copyOf((Collection)this.lookupProvider.getAllLookupNames());
        long lookupFootprint = 0L;
        for (String lookupName : lookupNames) {
            LookupExtractorFactoryContainer container = this.lookupProvider.get(lookupName).orElse(null);
            if (container == null) continue;
            try {
                LookupExtractor extractor = (LookupExtractor)container.getLookupExtractorFactory().get();
                lookupFootprint += extractor.estimateHeapFootprint();
            }
            catch (Exception e) {
                log.noStackTrace().warn((Throwable)e, "Failed to load lookup[%s] for size estimation. Skipping.", new Object[]{lookupName});
            }
        }
        log.info("Lookup footprint: lookup count[%d], total bytes[%,d].", new Object[]{lookupNames.size(), lookupFootprint});
        return lookupFootprint;
    }
}

