/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.List;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.annotations.LoadScope;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.metadata.input.InputSourceModule;
import org.apache.druid.msq.guice.MultiStageQuery;
import org.apache.druid.msq.indexing.destination.MSQTerminalStageSpecFactory;
import org.apache.druid.msq.indexing.destination.SegmentGenerationTerminalStageSpecFactory;
import org.apache.druid.msq.sql.MSQTaskSqlEngine;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.external.ExternalOperatorConversion;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.guice.SqlBindings;

@LoadScope(roles={"broker"})
public class MSQSqlModule
implements DruidModule {
    public List<? extends com.fasterxml.jackson.databind.Module> getJacksonModules() {
        return new InputSourceModule().getJacksonModules();
    }

    public void configure(Binder binder) {
        binder.install((Module)new InputSourceModule());
        binder.bind(MSQTerminalStageSpecFactory.class).to(SegmentGenerationTerminalStageSpecFactory.class).in(LazySingleton.class);
        binder.bind(MSQTaskSqlEngine.class).in(LazySingleton.class);
        SqlBindings.addOperatorConversion((Binder)binder, ExternalOperatorConversion.class);
    }

    @Provides
    @MultiStageQuery
    @LazySingleton
    public SqlStatementFactory makeMSQSqlStatementFactory(MSQTaskSqlEngine engine, SqlToolbox toolbox) {
        return new SqlStatementFactory(toolbox.withEngine((SqlEngine)engine));
    }
}

