/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.destination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.destination.MSQSelectDestination;
import org.apache.druid.msq.querykit.ShuffleSpecFactories;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.server.security.Resource;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.storage.ExportStorageProvider;

public class ExportMSQDestination
implements MSQDestination {
    public static final String TYPE = "export";
    private final ExportStorageProvider exportStorageProvider;
    private final ResultFormat resultFormat;

    @JsonCreator
    public ExportMSQDestination(@JsonProperty(value="exportStorageProvider") ExportStorageProvider exportStorageProvider, @JsonProperty(value="resultFormat") ResultFormat resultFormat) {
        this.exportStorageProvider = exportStorageProvider;
        this.resultFormat = resultFormat;
    }

    @JsonProperty(value="exportStorageProvider")
    public ExportStorageProvider getExportStorageProvider() {
        return this.exportStorageProvider;
    }

    @JsonProperty(value="resultFormat")
    public ResultFormat getResultFormat() {
        return this.resultFormat;
    }

    @Override
    public long getRowsInTaskReport() {
        return 0L;
    }

    @Override
    public MSQSelectDestination toSelectDestination() {
        return MSQSelectDestination.EXPORT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportMSQDestination that = (ExportMSQDestination)o;
        return Objects.equals(this.exportStorageProvider, that.exportStorageProvider) && this.resultFormat == that.resultFormat;
    }

    public int hashCode() {
        return Objects.hash(this.exportStorageProvider, this.resultFormat);
    }

    public String toString() {
        return "ExportMSQDestination{exportStorageProvider=" + this.exportStorageProvider + ", resultFormat=" + this.resultFormat + '}';
    }

    @Override
    public ShuffleSpecFactory getShuffleSpecFactory(int targetSize) {
        return ShuffleSpecFactories.getGlobalSortWithTargetSize(targetSize);
    }

    @Override
    public Optional<Resource> getDestinationResource() {
        return Optional.of(new Resource(this.getExportStorageProvider().getResourceType(), "EXTERNAL"));
    }
}

