/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Comparator;
import java.util.Objects;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;

public class StageId
implements Comparable<StageId> {
    private static final Comparator<StageId> COMPARATOR = Comparator.comparing(StageId::getQueryId).thenComparing(StageId::getStageNumber);
    private final String queryId;
    private final int stageNumber;

    public StageId(String queryId, int stageNumber) {
        if (stageNumber < 0) {
            throw new IAE("Invalid stageNumber [%s]", new Object[]{stageNumber});
        }
        this.queryId = IdUtils.validateId((String)"queryId", (String)queryId);
        this.stageNumber = stageNumber;
    }

    @JsonCreator
    public static StageId fromString(String s) {
        Long stageNumber;
        int lastUnderscore = s.lastIndexOf(95);
        if (lastUnderscore > 0 && lastUnderscore < s.length() - 1 && (stageNumber = GuavaUtils.tryParseLong((String)s.substring(lastUnderscore + 1))) != null && stageNumber >= 0L && stageNumber <= Integer.MAX_VALUE) {
            return new StageId(s.substring(0, lastUnderscore), stageNumber.intValue());
        }
        throw new IAE("Not a valid stage id: [%s]", new Object[]{s});
    }

    public String getQueryId() {
        return this.queryId;
    }

    public int getStageNumber() {
        return this.stageNumber;
    }

    @Override
    public int compareTo(StageId that) {
        return COMPARATOR.compare(this, that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageId stageId = (StageId)o;
        return this.stageNumber == stageId.stageNumber && Objects.equals(this.queryId, stageId.queryId);
    }

    public int hashCode() {
        return Objects.hash(this.queryId, this.stageNumber);
    }

    @JsonValue
    public String toString() {
        return StringUtils.format((String)"%s_%s", (Object[])new Object[]{this.queryId, this.stageNumber});
    }
}

