/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.manager.ProcessorAndCallback;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.querykit.BaseLeafFrameProcessorFactory;
import org.apache.druid.msq.querykit.LazyResourceHolder;
import org.apache.druid.segment.SegmentReference;

public class BaseLeafFrameProcessorManager
implements ProcessorManager<Object, Long> {
    private static final Logger log = new Logger(BaseLeafFrameProcessorManager.class);
    @Nullable
    private Iterator<ReadableInput> baseInputIterator;
    private final Function<SegmentReference, SegmentReference> segmentMapFn;
    private final AtomicReference<Queue<FrameWriterFactory>> frameWriterFactoryQueueRef;
    private final AtomicReference<Queue<WritableFrameChannel>> channelQueueRef;
    private final FrameContext frameContext;
    private final BaseLeafFrameProcessorFactory parentFactory;

    BaseLeafFrameProcessorManager(Iterable<ReadableInput> baseInputs, Function<SegmentReference, SegmentReference> segmentMapFn, Queue<FrameWriterFactory> frameWriterFactoryQueue, Queue<WritableFrameChannel> channelQueue, FrameContext frameContext, BaseLeafFrameProcessorFactory parentFactory) {
        this.baseInputIterator = baseInputs.iterator();
        this.segmentMapFn = segmentMapFn;
        this.frameWriterFactoryQueueRef = new AtomicReference<Queue<FrameWriterFactory>>(frameWriterFactoryQueue);
        this.channelQueueRef = new AtomicReference<Queue<WritableFrameChannel>>(channelQueue);
        this.frameContext = frameContext;
        this.parentFactory = parentFactory;
    }

    public ListenableFuture<Optional<ProcessorAndCallback<Object>>> next() {
        if (this.baseInputIterator == null) {
            throw new NoSuchElementException();
        }
        if (this.baseInputIterator.hasNext()) {
            ReadableInput baseInput = this.baseInputIterator.next();
            FrameProcessor<Object> processor = this.parentFactory.makeProcessor(baseInput, this.segmentMapFn, BaseLeafFrameProcessorManager.makeLazyResourceHolder(this.channelQueueRef, channel -> {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }), BaseLeafFrameProcessorManager.makeLazyResourceHolder(this.frameWriterFactoryQueueRef, ignored -> {}), this.frameContext);
            return Futures.immediateFuture(Optional.of(new ProcessorAndCallback(processor, null)));
        }
        this.baseInputIterator = null;
        return Futures.immediateFuture(Optional.empty());
    }

    public Long result() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        WritableFrameChannel c;
        Queue channelQueue;
        AtomicReference<Queue<WritableFrameChannel>> atomicReference = this.channelQueueRef;
        synchronized (atomicReference) {
            channelQueue = this.channelQueueRef.getAndSet(null);
        }
        while ((c = (WritableFrameChannel)channelQueue.poll()) != null) {
            try {
                c.close();
            }
            catch (Throwable e) {
                log.warn(e, "Error encountered while closing channel for [%s]", new Object[]{this});
            }
        }
    }

    private static <T> ResourceHolder<T> makeLazyResourceHolder(final AtomicReference<Queue<T>> queueRef, final Consumer<T> backupCloser) {
        return new LazyResourceHolder(() -> {
            Object resource;
            AtomicReference atomicReference = queueRef;
            synchronized (atomicReference) {
                resource = ((Queue)queueRef.get()).poll();
            }
            return new ResourceHolder<T>(){

                public T get() {
                    return resource;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void close() {
                    AtomicReference atomicReference = queueRef;
                    synchronized (atomicReference) {
                        Queue queue = (Queue)queueRef.get();
                        if (queue != null) {
                            queue.add(resource);
                            return;
                        }
                    }
                    backupCloser.accept(resource);
                }
            };
        });
    }
}

