/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.PeriodGranularity;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.msq.indexing.error.ColumnNameRestrictedFault;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.query.Query;
import org.apache.druid.query.expression.TimestampFloorExprMacro;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.joda.time.DateTimeZone;

public class QueryKitUtils {
    public static final String PARTITION_BOOST_COLUMN = "__boost";
    public static final String SEGMENT_GRANULARITY_COLUMN = "__bucket";
    public static final String CTX_TIME_COLUMN_NAME = "__timeColumn";

    public static Granularity getSegmentGranularityFromContext(ObjectMapper objectMapper, @Nullable Map<String, Object> context) {
        Object o;
        Object object = o = context == null ? null : context.get("sqlInsertSegmentGranularity");
        if (o instanceof String) {
            try {
                return (Granularity)objectMapper.readValue((String)o, Granularity.class);
            }
            catch (JsonProcessingException e) {
                throw new ISE("Invalid segment granularity [%s]", new Object[]{o});
            }
        }
        if (o == null) {
            return Granularities.ALL;
        }
        throw new ISE("Invalid segment granularity [%s]", new Object[]{o});
    }

    public static ClusterBy clusterByWithSegmentGranularity(ClusterBy clusterBy, Granularity segmentGranularity) {
        if (Granularities.ALL.equals(segmentGranularity)) {
            return clusterBy;
        }
        ArrayList<KeyColumn> newColumns = new ArrayList<KeyColumn>(clusterBy.getColumns().size() + 1);
        newColumns.add(new KeyColumn(SEGMENT_GRANULARITY_COLUMN, KeyOrder.ASCENDING));
        newColumns.addAll(clusterBy.getColumns());
        return new ClusterBy(newColumns, 1);
    }

    public static void verifyRowSignature(RowSignature signature) {
        if (signature.contains(PARTITION_BOOST_COLUMN)) {
            throw new MSQException(new ColumnNameRestrictedFault(PARTITION_BOOST_COLUMN));
        }
        if (signature.contains(SEGMENT_GRANULARITY_COLUMN)) {
            throw new MSQException(new ColumnNameRestrictedFault(SEGMENT_GRANULARITY_COLUMN));
        }
    }

    public static RowSignature signatureWithSegmentGranularity(RowSignature signature, Granularity segmentGranularity) {
        if (Granularities.ALL.equals(segmentGranularity)) {
            return signature;
        }
        return RowSignature.builder().addAll(signature).add(SEGMENT_GRANULARITY_COLUMN, ColumnType.LONG).build();
    }

    public static RowSignature sortableSignature(RowSignature signature, List<KeyColumn> clusterByColumns) {
        RowSignature.Builder builder = RowSignature.builder();
        for (KeyColumn columnName : clusterByColumns) {
            Optional columnType = signature.getColumnType(columnName.columnName());
            if (!columnType.isPresent()) {
                throw new IAE("Column [%s] not present in signature", new Object[]{columnName});
            }
            builder.add(columnName.columnName(), (ColumnType)columnType.get());
        }
        Set clusterByColumnNames = clusterByColumns.stream().map(KeyColumn::columnName).collect(Collectors.toSet());
        for (int i = 0; i < signature.size(); ++i) {
            String columnName = signature.getColumnName(i);
            if (clusterByColumnNames.contains(columnName)) continue;
            builder.add(columnName, (ColumnType)signature.getColumnType(i).orElse(null));
        }
        return builder.build();
    }

    @Nullable
    public static VirtualColumn makeSegmentGranularityVirtualColumn(ObjectMapper jsonMapper, Query<?> query) {
        Granularity segmentGranularity = QueryKitUtils.getSegmentGranularityFromContext(jsonMapper, query.getContext());
        String timeColumnName = query.context().getString(CTX_TIME_COLUMN_NAME);
        if (timeColumnName == null || Granularities.ALL.equals(segmentGranularity)) {
            return null;
        }
        if (!(segmentGranularity instanceof PeriodGranularity)) {
            throw new IAE("Granularity [%s] is not supported", new Object[]{segmentGranularity});
        }
        PeriodGranularity periodSegmentGranularity = (PeriodGranularity)segmentGranularity;
        if (periodSegmentGranularity.getOrigin() != null || !periodSegmentGranularity.getTimeZone().equals((Object)DateTimeZone.UTC)) {
            throw new IAE("Granularity [%s] is not supported", new Object[]{segmentGranularity});
        }
        return new ExpressionVirtualColumn(SEGMENT_GRANULARITY_COLUMN, StringUtils.format((String)"timestamp_floor(%s, %s)", (Object[])new Object[]{CalciteSqlDialect.DEFAULT.quoteIdentifier(timeColumnName), Calcites.escapeStringLiteral((String)periodSegmentGranularity.getPeriod().toString())}), ColumnType.LONG, new ExprMacroTable(Collections.singletonList(new TimestampFloorExprMacro())));
    }
}

