/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.util.SettableLongVirtualColumn;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.Unit;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.TooManyRowsInAWindowFault;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.operator.OffsetLimit;
import org.apache.druid.query.operator.Operator;
import org.apache.druid.query.operator.OperatorFactory;
import org.apache.druid.query.operator.WindowOperatorQuery;
import org.apache.druid.query.rowsandcols.ConcatRowsAndColumns;
import org.apache.druid.query.rowsandcols.LazilyDecoratedRowsAndColumns;
import org.apache.druid.query.rowsandcols.MapOfColumnsRowsAndColumns;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.concrete.RowBasedFrameRowsAndColumns;
import org.apache.druid.query.rowsandcols.semantic.ColumnSelectorFactoryMaker;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.RowSignature;

public class WindowOperatorQueryFrameProcessor
implements FrameProcessor<Object> {
    private static final Logger log = new Logger(WindowOperatorQueryFrameProcessor.class);
    private final WindowOperatorQuery query;
    private final List<OperatorFactory> operatorFactoryList;
    private final List<String> partitionColumnNames;
    private final ObjectMapper jsonMapper;
    private final ArrayList<RowsAndColumns> frameRowsAndCols;
    private final ArrayList<RowsAndColumns> resultRowAndCols;
    private final ReadableFrameChannel inputChannel;
    private final WritableFrameChannel outputChannel;
    private final FrameWriterFactory frameWriterFactory;
    private final FrameReader frameReader;
    private final int maxRowsMaterialized;
    private Cursor frameCursor = null;
    private Supplier<ResultRow> rowSupplierFromFrameCursor;
    private ResultRow outputRow = null;
    private FrameWriter frameWriter = null;
    private final VirtualColumns frameWriterVirtualColumns;
    private final SettableLongVirtualColumn partitionBoostVirtualColumn;
    private final NullableTypeStrategy[] typeStrategies;
    private final ArrayList<ResultRow> rowsToProcess;
    private int lastPartitionIndex = -1;
    final AtomicInteger rowId = new AtomicInteger(0);

    public WindowOperatorQueryFrameProcessor(WindowOperatorQuery query, ReadableFrameChannel inputChannel, WritableFrameChannel outputChannel, FrameWriterFactory frameWriterFactory, FrameReader frameReader, ObjectMapper jsonMapper, List<OperatorFactory> operatorFactoryList, RowSignature rowSignature, int maxRowsMaterializedInWindow, List<String> partitionColumnNames) {
        this.inputChannel = inputChannel;
        this.outputChannel = outputChannel;
        this.frameWriterFactory = frameWriterFactory;
        this.operatorFactoryList = operatorFactoryList;
        this.jsonMapper = jsonMapper;
        this.query = query;
        this.frameRowsAndCols = new ArrayList();
        this.resultRowAndCols = new ArrayList();
        this.rowsToProcess = new ArrayList();
        this.maxRowsMaterialized = maxRowsMaterializedInWindow;
        this.partitionColumnNames = partitionColumnNames;
        this.frameReader = frameReader;
        this.typeStrategies = new NullableTypeStrategy[frameReader.signature().size()];
        for (int i = 0; i < frameReader.signature().size(); ++i) {
            this.typeStrategies[i] = ((ColumnType)frameReader.signature().getColumnType(i).get()).getNullableStrategy();
        }
        this.partitionBoostVirtualColumn = new SettableLongVirtualColumn("__boost");
        ArrayList<Object> frameWriterVirtualColumns = new ArrayList<Object>();
        VirtualColumn segmentGranularityVirtualColumn = QueryKitUtils.makeSegmentGranularityVirtualColumn(jsonMapper, query);
        if (segmentGranularityVirtualColumn != null) {
            frameWriterVirtualColumns.add(segmentGranularityVirtualColumn);
        }
        frameWriterVirtualColumns.add(this.partitionBoostVirtualColumn);
        this.frameWriterVirtualColumns = VirtualColumns.create(frameWriterVirtualColumns);
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.inputChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    public ReturnOrAwait<Object> runIncrementally(IntSet readableInputs) throws IOException {
        if (this.frameHasRowsPendingFlush()) {
            this.flushAllRowsAndCols();
            return ReturnOrAwait.runAgain();
        }
        if (this.partitionColumnNames.isEmpty()) {
            if (this.inputChannel.canRead()) {
                Frame frame = this.inputChannel.read();
                this.convertRowFrameToRowsAndColumns(frame);
                return ReturnOrAwait.runAgain();
            }
            if (this.inputChannel.isFinished()) {
                if (this.rowId.get() == 0) {
                    this.runAllOpsOnMultipleRac(this.frameRowsAndCols);
                }
                if (this.frameHasRowsPendingFlush()) {
                    return ReturnOrAwait.runAgain();
                }
                return ReturnOrAwait.returnObject((Object)Unit.instance());
            }
            return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
        }
        if (this.frameCursor == null || this.frameCursor.isDone()) {
            if (readableInputs.isEmpty()) {
                return ReturnOrAwait.awaitAll((int)1);
            }
            if (this.inputChannel.canRead()) {
                Frame frame = this.inputChannel.read();
                this.frameCursor = FrameProcessors.makeCursor((Frame)frame, (FrameReader)this.frameReader);
                this.makeRowSupplierFromFrameCursor();
            } else {
                if (this.inputChannel.isFinished()) {
                    if (!this.rowsToProcess.isEmpty()) {
                        this.lastPartitionIndex = this.rowsToProcess.size() - 1;
                        this.processRowsUpToLastPartition();
                        return ReturnOrAwait.runAgain();
                    }
                    return ReturnOrAwait.returnObject((Object)Unit.instance());
                }
                return ReturnOrAwait.runAgain();
            }
        }
        while (!this.frameCursor.isDone()) {
            ResultRow currentRow = this.rowSupplierFromFrameCursor.get();
            if (this.outputRow == null) {
                this.outputRow = currentRow;
                this.rowsToProcess.add(currentRow);
            } else if (this.comparePartitionKeys(this.outputRow, currentRow, this.partitionColumnNames)) {
                this.rowsToProcess.add(currentRow);
            } else {
                this.lastPartitionIndex = this.rowsToProcess.size() - 1;
                this.outputRow = currentRow.copy();
                this.rowsToProcess.add(currentRow);
            }
            this.frameCursor.advance();
            if (this.rowsToProcess.size() <= this.maxRowsMaterialized) continue;
            this.processRowsUpToLastPartition();
            this.ensureMaxRowsInAWindowConstraint(this.rowsToProcess.size());
            return ReturnOrAwait.runAgain();
        }
        return ReturnOrAwait.runAgain();
    }

    private void runAllOpsOnMultipleRac(final ArrayList<RowsAndColumns> listOfRacs) {
        Operator op = new Operator(){

            @Nullable
            public Closeable goOrContinue(Closeable continuationObject, Operator.Receiver receiver) {
                ConcatRowsAndColumns rac = new ConcatRowsAndColumns(listOfRacs);
                WindowOperatorQueryFrameProcessor.this.ensureMaxRowsInAWindowConstraint(rac.numRows());
                receiver.push((RowsAndColumns)rac);
                receiver.completed();
                return null;
            }
        };
        this.runOperatorsAfterThis(op);
    }

    private void runOperatorsAfterThis(Operator op) {
        for (OperatorFactory of : this.operatorFactoryList) {
            op = of.wrap(op);
        }
        Operator.go((Operator)op, (Operator.Receiver)new Operator.Receiver(){

            public Operator.Signal push(RowsAndColumns rac) {
                WindowOperatorQueryFrameProcessor.this.resultRowAndCols.add(rac);
                return Operator.Signal.GO;
            }

            public void completed() {
                try {
                    WindowOperatorQueryFrameProcessor.this.flushAllRowsAndCols();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void flushAllRowsAndCols() throws IOException {
        ConcatRowsAndColumns rac = new ConcatRowsAndColumns(this.resultRowAndCols);
        this.createFrameWriterIfNeeded((RowsAndColumns)rac);
        this.writeRacToFrame((RowsAndColumns)rac);
    }

    private void createFrameWriterIfNeeded(RowsAndColumns rac) {
        if (this.frameWriter == null) {
            ColumnSelectorFactoryMaker csfm = ColumnSelectorFactoryMaker.fromRAC((RowsAndColumns)rac);
            ColumnSelectorFactory frameWriterColumnSelectorFactory = csfm.make(this.rowId);
            ColumnSelectorFactory frameWriterColumnSelectorFactoryWithVirtualColumns = this.frameWriterVirtualColumns.wrap(frameWriterColumnSelectorFactory);
            this.frameWriter = this.frameWriterFactory.newFrameWriter(frameWriterColumnSelectorFactoryWithVirtualColumns);
        }
    }

    public void writeRacToFrame(RowsAndColumns rac) throws IOException {
        int numRows = rac.numRows();
        while (this.rowId.get() < numRows) {
            if (this.frameWriter.addSelection()) {
                this.incrementBoostColumn();
                this.rowId.incrementAndGet();
                continue;
            }
            if (this.frameWriter.getNumRows() > 0) {
                this.flushFrameWriter();
                this.createFrameWriterIfNeeded(rac);
                if (this.frameWriter.addSelection()) {
                    this.incrementBoostColumn();
                    this.rowId.incrementAndGet();
                    return;
                }
                throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
            }
            throw new FrameRowTooLargeException(this.frameWriterFactory.allocatorCapacity());
        }
        this.flushFrameWriter();
        this.clearRACBuffers();
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[]{this.frameWriter});
    }

    private long flushFrameWriter() throws IOException {
        if (this.frameWriter == null || this.frameWriter.getNumRows() <= 0) {
            if (this.frameWriter != null) {
                this.frameWriter.close();
                this.frameWriter = null;
            }
            return 0L;
        }
        Frame frame = Frame.wrap((byte[])this.frameWriter.toByteArray());
        ((WritableFrameChannel)Iterables.getOnlyElement(this.outputChannels())).write(new FrameWithPartition(frame, -1));
        this.frameWriter.close();
        this.frameWriter = null;
        return frame.numRows();
    }

    private void convertRowFrameToRowsAndColumns(Frame frame) {
        RowSignature signature = this.frameReader.signature();
        RowBasedFrameRowsAndColumns frameRowsAndColumns = new RowBasedFrameRowsAndColumns(frame, signature);
        LazilyDecoratedRowsAndColumns ldrc = new LazilyDecoratedRowsAndColumns((RowsAndColumns)frameRowsAndColumns, null, null, null, OffsetLimit.limit((int)Integer.MAX_VALUE), null, null);
        this.ensureMaxRowsInAWindowConstraint(this.frameRowsAndCols.size() + ldrc.numRows());
        this.frameRowsAndCols.add((RowsAndColumns)ldrc);
    }

    private boolean comparePartitionKeys(ResultRow row1, ResultRow row2, List<String> partitionColumnNames) {
        int match = 0;
        for (String columnName : partitionColumnNames) {
            int i = this.frameReader.signature().indexOf(columnName);
            if (ColumnType.STRING.equals(this.frameReader.signature().getColumnType(columnName).get()) && (row1.get(i) instanceof List || row2.get(i) instanceof List)) {
                throw new UOE("Encountered a multi value column [%s]. Window processing does not support MVDs. Consider using UNNEST or MV_TO_ARRAY.", new Object[]{columnName});
            }
            if (this.typeStrategies[i].compare(row1.get(i), row2.get(i)) != 0) continue;
            ++match;
        }
        return match == partitionColumnNames.size();
    }

    private void makeRowSupplierFromFrameCursor() {
        ColumnSelectorFactory frameColumnSelectorFactory = this.frameCursor.getColumnSelectorFactory();
        Supplier[] fieldSuppliers = new Supplier[this.frameReader.signature().size()];
        for (int i = 0; i < fieldSuppliers.length; ++i) {
            ColumnValueSelector selector = frameColumnSelectorFactory.makeColumnValueSelector(this.frameReader.signature().getColumnName(i));
            fieldSuppliers[i] = () -> ((ColumnValueSelector)selector).getObject();
        }
        this.rowSupplierFromFrameCursor = () -> {
            ResultRow row = ResultRow.create((int)fieldSuppliers.length);
            for (int i = 0; i < fieldSuppliers.length; ++i) {
                row.set(i, fieldSuppliers[i].get());
            }
            return row;
        };
    }

    private void processRowsUpToLastPartition() {
        if (this.lastPartitionIndex == -1) {
            return;
        }
        MapOfColumnsRowsAndColumns singleRac = MapOfColumnsRowsAndColumns.fromResultRowTillIndex(this.rowsToProcess, (RowSignature)this.frameReader.signature(), (int)this.lastPartitionIndex);
        ArrayList<RowsAndColumns> rowsAndColumns = new ArrayList<RowsAndColumns>();
        rowsAndColumns.add((RowsAndColumns)singleRac);
        this.runAllOpsOnMultipleRac(rowsAndColumns);
        this.rowsToProcess.subList(0, this.lastPartitionIndex + 1).clear();
        this.lastPartitionIndex = -1;
    }

    private void ensureMaxRowsInAWindowConstraint(int numRowsInWindow) {
        if (numRowsInWindow > this.maxRowsMaterialized) {
            throw new MSQException(new TooManyRowsInAWindowFault(numRowsInWindow, this.maxRowsMaterialized));
        }
    }

    private void incrementBoostColumn() {
        this.partitionBoostVirtualColumn.setValue(this.partitionBoostVirtualColumn.getValue() + 1L);
    }

    private boolean frameHasRowsPendingFlush() {
        return this.frameWriter != null && this.frameWriter.getNumRows() > 0;
    }

    private void clearRACBuffers() {
        this.frameRowsAndCols.clear();
        this.resultRowAndCols.clear();
        this.rowId.set(0);
    }
}

