/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.scan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.querykit.BaseLeafFrameProcessorFactory;
import org.apache.druid.msq.querykit.scan.ScanQueryFrameProcessor;
import org.apache.druid.query.Query;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.SegmentReference;

@JsonTypeName(value="scan")
public class ScanQueryFrameProcessorFactory
extends BaseLeafFrameProcessorFactory {
    private final ScanQuery query;
    @Nullable
    private final AtomicLong runningCountForLimit;

    @JsonCreator
    public ScanQueryFrameProcessorFactory(@JsonProperty(value="query") ScanQuery query) {
        super((Query<?>)query);
        this.query = (ScanQuery)Preconditions.checkNotNull((Object)query, (Object)"query");
        this.runningCountForLimit = query.isLimited() && query.getOrderBys().isEmpty() ? new AtomicLong() : null;
    }

    @JsonProperty
    public ScanQuery getQuery() {
        return this.query;
    }

    @Override
    protected FrameProcessor<Object> makeProcessor(ReadableInput baseInput, Function<SegmentReference, SegmentReference> segmentMapFn, ResourceHolder<WritableFrameChannel> outputChannelHolder, ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder, FrameContext frameContext) {
        return new ScanQueryFrameProcessor(this.query, this.runningCountForLimit, frameContext.jsonMapper(), baseInput, segmentMapFn, outputChannelHolder, frameWriterFactoryHolder);
    }

    @Override
    public boolean usesProcessingBuffers() {
        return false;
    }
}

