/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.rpc;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.druid.msq.rpc.ResourcePermissionMapper;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.ResourceAction;

public class MSQResourceUtils {
    public static void authorizeAdminRequest(ResourcePermissionMapper permissionMapper, AuthorizerMapper authorizerMapper, HttpServletRequest request) {
        List<ResourceAction> resourceActions = permissionMapper.getAdminPermissions();
        Access access = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)request, resourceActions, (AuthorizerMapper)authorizerMapper);
        if (!access.isAllowed()) {
            throw new ForbiddenException(access.toString());
        }
    }

    public static void authorizeQueryRequest(ResourcePermissionMapper permissionMapper, AuthorizerMapper authorizerMapper, HttpServletRequest request, String queryId) {
        List<ResourceAction> resourceActions = permissionMapper.getQueryPermissions(queryId);
        Access access = AuthorizationUtils.authorizeAllResourceActions((HttpServletRequest)request, resourceActions, (AuthorizerMapper)authorizerMapper);
        if (!access.isAllowed()) {
            throw new ForbiddenException(access.toString());
        }
    }
}

