/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.input;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.kernel.StageId;

public class MetaInputChannelFactory
implements InputChannelFactory {
    private final Int2ObjectMap<OutputChannelMode> stageOutputModeMap;
    private final Function<OutputChannelMode, InputChannelFactory> inputChannelFactoryProvider;
    private final Map<OutputChannelMode, InputChannelFactory> inputChannelFactoryMap = new HashMap<OutputChannelMode, InputChannelFactory>();

    public MetaInputChannelFactory(Int2ObjectMap<OutputChannelMode> stageOutputModeMap, Function<OutputChannelMode, InputChannelFactory> inputChannelFactoryProvider) {
        this.stageOutputModeMap = stageOutputModeMap;
        this.inputChannelFactoryProvider = inputChannelFactoryProvider;
    }

    public static MetaInputChannelFactory create(List<StageInputSlice> slices, OutputChannelMode defaultOutputChannelMode, Function<OutputChannelMode, InputChannelFactory> inputChannelFactoryProvider) {
        Int2ObjectOpenHashMap stageOutputModeMap = new Int2ObjectOpenHashMap();
        for (StageInputSlice slice : slices) {
            OutputChannelMode newMode = slice.getOutputChannelMode() != null ? slice.getOutputChannelMode() : defaultOutputChannelMode;
            OutputChannelMode prevMode = (OutputChannelMode)((Object)stageOutputModeMap.putIfAbsent(slice.getStageNumber(), (Object)newMode));
            if (prevMode == null || prevMode == newMode) continue;
            throw new ISE("Inconsistent output modes for stage[%s], got[%s] and[%s]", new Object[]{slice.getStageNumber(), prevMode, newMode});
        }
        return new MetaInputChannelFactory((Int2ObjectMap<OutputChannelMode>)stageOutputModeMap, inputChannelFactoryProvider);
    }

    @Override
    public ReadableFrameChannel openChannel(StageId stageId, int workerNumber, int partitionNumber) throws IOException {
        OutputChannelMode outputChannelMode = (OutputChannelMode)((Object)this.stageOutputModeMap.get(stageId.getStageNumber()));
        if (outputChannelMode == null) {
            throw new ISE("No output mode for stageNumber[%s]", new Object[]{stageId.getStageNumber()});
        }
        return this.inputChannelFactoryMap.computeIfAbsent(outputChannelMode, this.inputChannelFactoryProvider).openChannel(stageId, workerNumber, partitionNumber);
    }
}

