/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.output;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.msq.shuffle.output.StageOutputReader;

public class NilStageOutputReader
implements StageOutputReader {
    public static final NilStageOutputReader INSTANCE = new NilStageOutputReader();
    private static final byte[] EMPTY_FRAME_FILE;

    @Override
    public ListenableFuture<InputStream> readRemotelyFrom(long offset) {
        ByteArrayInputStream in = new ByteArrayInputStream(EMPTY_FRAME_FILE);
        in.skip(offset);
        return Futures.immediateFuture((Object)in);
    }

    @Override
    public ReadableFrameChannel readLocally() {
        return ReadableNilFrameChannel.INSTANCE;
    }

    @Override
    public void close() {
    }

    static {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FrameFileWriter.open((WritableByteChannel)Channels.newChannel(baos), null, (ByteTracker)ByteTracker.unboundedTracker()).close();
            EMPTY_FRAME_FILE = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

