/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.sql.resources;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CountingOutputStream;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.error.QueryExceptionCompat;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.guice.MultiStageQuery;
import org.apache.druid.msq.sql.MSQTaskSqlEngine;
import org.apache.druid.msq.sql.SqlTaskStatus;
import org.apache.druid.query.QueryException;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.sql.DirectStatement;
import org.apache.druid.sql.HttpStatement;
import org.apache.druid.sql.SqlRowTransformer;
import org.apache.druid.sql.SqlStatementFactory;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.sql.http.SqlQuery;

@Path(value="/druid/v2/sql/task/")
public class SqlTaskResource {
    private static final Logger log = new Logger(SqlTaskResource.class);
    private final SqlStatementFactory sqlStatementFactory;
    private final ServerConfig serverConfig;
    private final AuthorizerMapper authorizerMapper;
    private final ObjectMapper jsonMapper;

    @Inject
    public SqlTaskResource(@MultiStageQuery SqlStatementFactory sqlStatementFactory, ServerConfig serverConfig, AuthorizerMapper authorizerMapper, ObjectMapper jsonMapper) {
        this.sqlStatementFactory = sqlStatementFactory;
        this.serverConfig = serverConfig;
        this.authorizerMapper = authorizerMapper;
        this.jsonMapper = jsonMapper;
    }

    @GET
    @Path(value="/enabled")
    @Produces(value={"application/json"})
    public Response doGetEnabled(@Context HttpServletRequest request) {
        AuthorizationUtils.setRequestAuthorizationAttributeIfNeeded((HttpServletRequest)request);
        return Response.ok((Object)ImmutableMap.of((Object)"enabled", (Object)true)).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response doPost(SqlQuery sqlQuery, @Context HttpServletRequest req) {
        Response response;
        QueryResponse response2;
        HttpStatement stmt = this.sqlStatementFactory.httpStatement(sqlQuery, req);
        String sqlQueryId = stmt.sqlQueryId();
        try {
            DirectStatement.ResultSet plan = stmt.plan();
            response2 = plan.run();
            Sequence sequence = response2.getResults();
            SqlRowTransformer rowTransformer = plan.createRowTransformer();
            boolean isTaskStruct = MSQTaskSqlEngine.TASK_STRUCT_FIELD_NAMES.equals(rowTransformer.getFieldList());
            if (isTaskStruct) {
                Response response3 = this.buildTaskResponse((Sequence<Object[]>)sequence);
                return response3;
            }
            Response response4 = this.buildStandardResponse((Sequence<Object[]>)sequence, sqlQuery, sqlQueryId, rowTransformer);
            return response4;
        }
        catch (DruidException e) {
            stmt.reporter().failed((Throwable)e);
            response2 = this.buildNonOkResponse(sqlQueryId, e);
            return response2;
        }
        catch (QueryException queryException) {
            stmt.reporter().failed((Throwable)queryException);
            DruidException underlyingException = DruidException.fromFailure((DruidException.Failure)new QueryExceptionCompat(queryException));
            Response response5 = this.buildNonOkResponse(sqlQueryId, underlyingException);
            return response5;
        }
        catch (ForbiddenException e) {
            log.debug("Got forbidden request for reason [%s]", new Object[]{e.getErrorMessage()});
            response = this.buildNonOkResponse("forbidden", DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.FORBIDDEN).build("Unauthorized", new Object[0]));
            return response;
        }
        catch (AssertionError | Exception e) {
            stmt.reporter().failed((Throwable)e);
            log.noStackTrace().warn((Throwable)e, "Failed to handle query: %s", new Object[]{sqlQueryId});
            response = this.buildNonOkResponse(sqlQueryId, DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build("%s", new Object[]{((Throwable)e).getMessage()}));
            return response;
        }
        finally {
            stmt.close();
        }
    }

    private Response buildTaskResponse(Sequence<Object[]> sequence) throws IOException {
        String taskId = null;
        try (Yielder yielder = Yielders.each(sequence);){
            while (!yielder.isDone()) {
                Object[] row = (Object[])yielder.get();
                if (taskId == null && row.length > 0) {
                    taskId = (String)row[0];
                }
                yielder = yielder.next(null);
            }
        }
        if (taskId == null) {
            return this.buildNonOkResponse(null, DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.DEFENSIVE).build("Failed to issue query task", new Object[0]));
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)new SqlTaskStatus(taskId, TaskState.RUNNING, null)).build();
    }

    private Response buildStandardResponse(Sequence<Object[]> sequence, SqlQuery sqlQuery, String sqlQueryId, SqlRowTransformer rowTransformer) throws IOException {
        Yielder yielder0 = Yielders.each(sequence);
        try {
            Response.ResponseBuilder responseBuilder = Response.ok(outputStream -> {
                CountingOutputStream os = new CountingOutputStream(outputStream);
                try (Yielder yielder = yielder0;
                     ResultFormat.Writer writer = sqlQuery.getResultFormat().createFormatter((OutputStream)os, this.jsonMapper);){
                    writer.writeResponseStart();
                    if (sqlQuery.includeHeader()) {
                        writer.writeHeader(rowTransformer.getRowType(), sqlQuery.includeTypesHeader(), sqlQuery.includeSqlTypesHeader());
                    }
                    while (!yielder.isDone()) {
                        Object[] row = (Object[])yielder.get();
                        writer.writeRowStart();
                        for (int i = 0; i < rowTransformer.getFieldList().size(); ++i) {
                            Object value = rowTransformer.transform(row, i);
                            writer.writeRowField((String)rowTransformer.getFieldList().get(i), value);
                        }
                        writer.writeRowEnd();
                        yielder = yielder.next(null);
                    }
                    writer.writeResponseEnd();
                }
            });
            if (sqlQuery.includeHeader()) {
                responseBuilder.header("X-Druid-SQL-Header-Included", (Object)"yes");
            }
            return responseBuilder.build();
        }
        catch (Throwable e) {
            yielder0.close();
            throw e;
        }
    }

    private Response buildNonOkResponse(String sqlQueryId, DruidException exception) {
        return Response.status((int)exception.getStatusCode()).entity((Object)new SqlTaskStatus(sqlQueryId, TaskState.FAILED, new ErrorResponse(exception))).build();
    }
}

