/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogram;
import org.apache.druid.query.aggregation.histogram.ApproximateHistogramPostAggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogram;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="max")
public class MaxPostAggregator
extends ApproximateHistogramPostAggregator {
    static final Comparator COMPARATOR = Comparator.comparingDouble(o -> ((Number)o).doubleValue());

    @JsonCreator
    public MaxPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        super(name, fieldName);
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    public Set<String> getDependentFields() {
        return Sets.newHashSet((Object[])new String[]{this.fieldName});
    }

    @Override
    public Object compute(Map<String, Object> values) {
        Object val = values.get(this.fieldName);
        if (val instanceof ApproximateHistogram) {
            ApproximateHistogram ah = (ApproximateHistogram)val;
            return Float.valueOf(ah.getMax());
        }
        FixedBucketsHistogram fbh = (FixedBucketsHistogram)val;
        return fbh.getMax();
    }

    public ColumnType getType(ColumnInspector signature) {
        return ColumnType.DOUBLE;
    }

    public PostAggregator decorate(Map<String, AggregatorFactory> aggregators) {
        return this;
    }

    @Override
    public String toString() {
        return "MaxPostAggregator{fieldName='" + this.fieldName + '\'' + '}';
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(13).appendString(this.fieldName).build();
    }
}

