/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll.vector;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregatorHelper;
import org.apache.druid.query.aggregation.datasketches.hll.vector.HllSketchBuildVectorProcessor;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleHllSketchBuildVectorProcessor
implements HllSketchBuildVectorProcessor {
    private final HllSketchBuildBufferAggregatorHelper helper;
    private final VectorValueSelector selector;

    public DoubleHllSketchBuildVectorProcessor(HllSketchBuildBufferAggregatorHelper helper, VectorValueSelector selector) {
        this.helper = helper;
        this.selector = selector;
    }

    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        double[] vector = this.selector.getDoubleVector();
        boolean[] nullVector = this.selector.getNullVector();
        HllSketch sketch = this.helper.getSketchAtPosition(buf, position);
        for (int i = startRow; i < endRow; ++i) {
            if (!NullHandling.replaceWithDefault() && nullVector != null && nullVector[i]) continue;
            sketch.update(vector[i]);
        }
    }

    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        double[] vector = this.selector.getDoubleVector();
        boolean[] nullVector = this.selector.getNullVector();
        for (int i = 0; i < numRows; ++i) {
            int idx;
            int n = idx = rows != null ? rows[i] : i;
            if (!NullHandling.replaceWithDefault() && nullVector != null && nullVector[idx]) continue;
            int position = positions[i] + positionOffset;
            HllSketch sketch = this.helper.getSketchAtPosition(buf, position);
            sketch.update(vector[idx]);
        }
    }
}

