/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.util.Optionality;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DefaultOperandTypeChecker;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.PostAggregatorVisitor;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidTypeSystem;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class OperatorConversions {
    @Nullable
    public static DruidExpression convertDirectCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, String functionName) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, (List<DruidExpression> druidExpressions) -> DruidExpression.ofFunctionCall(Calcites.getColumnTypeForRelDataType(rexNode.getType()), functionName, druidExpressions));
    }

    @Nullable
    public static DruidExpression convertDirectCallWithExtraction(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, String functionName, Function<List<DruidExpression>, SimpleExtraction> simpleExtractionFunction) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, (List<DruidExpression> druidExpressions) -> DruidExpression.ofExpression(Calcites.getColumnTypeForRelDataType(rexNode.getType()), simpleExtractionFunction == null ? null : (SimpleExtraction)simpleExtractionFunction.apply(druidExpressions), DruidExpression.functionCall(functionName), druidExpressions));
    }

    @Nullable
    public static DruidExpression convertCallBuilder(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, DruidExpression.ExpressionGenerator expressionGenerator) {
        return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, (List<DruidExpression> operands) -> DruidExpression.ofExpression(Calcites.getColumnTypeForRelDataType(rexNode.getType()), expressionGenerator, operands));
    }

    @Nullable
    public static DruidExpression convertCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, DruidExpression.DruidExpressionCreator expressionFunction) {
        RexCall call = (RexCall)rexNode;
        List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands());
        if (druidExpressions == null) {
            return null;
        }
        return expressionFunction.create(druidExpressions);
    }

    @Deprecated
    @Nullable
    public static DruidExpression convertCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, String functionName) {
        return OperatorConversions.convertDirectCall(plannerContext, rowSignature, rexNode, functionName);
    }

    @Deprecated
    @Nullable
    public static DruidExpression convertCall(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, String functionName, Function<List<DruidExpression>, SimpleExtraction> simpleExtractionFunction) {
        return OperatorConversions.convertDirectCallWithExtraction(plannerContext, rowSignature, rexNode, functionName, simpleExtractionFunction);
    }

    public static <T> T getOperandWithDefault(List<RexNode> operands, int i, Function<RexNode, T> f, T defaultReturnValue) {
        if (operands.size() > i && !RexLiteral.isNullLiteral((RexNode)operands.get(i))) {
            return f.apply(operands.get(i));
        }
        return defaultReturnValue;
    }

    @Nullable
    public static DruidExpression convertCallWithPostAggOperands(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, DruidExpression.DruidExpressionCreator expressionFunction, PostAggregatorVisitor postAggregatorVisitor) {
        RexCall call = (RexCall)rexNode;
        List<DruidExpression> druidExpressions = Expressions.toDruidExpressionsWithPostAggOperands(plannerContext, rowSignature, call.getOperands(), postAggregatorVisitor);
        if (druidExpressions == null) {
            return null;
        }
        return expressionFunction.create(druidExpressions);
    }

    @Nullable
    public static PostAggregator toPostAggregator(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode, PostAggregatorVisitor postAggregatorVisitor, boolean useExpressions) {
        DruidExpression druidExpression;
        SqlKind kind = rexNode.getKind();
        if (kind == SqlKind.INPUT_REF) {
            RexInputRef ref = (RexInputRef)rexNode;
            String columnName = rowSignature.getColumnName(ref.getIndex());
            if (columnName == null) {
                throw new ISE("PostAggregator referred to nonexistent index[%d]", new Object[]{ref.getIndex()});
            }
            return new FieldAccessPostAggregator(postAggregatorVisitor.getOutputNamePrefix() + postAggregatorVisitor.getAndIncrementCounter(), columnName);
        }
        if (rexNode instanceof RexCall) {
            PostAggregator postAggregator;
            SqlOperator operator = ((RexCall)rexNode).getOperator();
            SqlOperatorConversion conversion = plannerContext.getPlannerToolbox().operatorTable().lookupOperatorConversion(operator);
            if (conversion != null && (postAggregator = conversion.toPostAggregator(plannerContext, rowSignature, rexNode, postAggregatorVisitor)) != null) {
                return postAggregator;
            }
        }
        if (useExpressions && (druidExpression = Expressions.toDruidExpression(plannerContext, rowSignature, rexNode)) != null) {
            return new ExpressionPostAggregator(postAggregatorVisitor.getOutputNamePrefix() + postAggregatorVisitor.getAndIncrementCounter(), druidExpression.getExpression(), null, druidExpression.getDruidType(), plannerContext.parseExpression(druidExpression.getExpression()));
        }
        if (rexNode instanceof RexCall || kind == SqlKind.LITERAL) {
            return null;
        }
        throw new IAE("Unknown rexnode kind: " + String.valueOf(kind), new Object[0]);
    }

    public static OperatorBuilder<SqlFunction> operatorBuilder(String name) {
        return new OperatorBuilder<SqlFunction>(name);
    }

    public static OperatorBuilder<SqlAggFunction> aggregatorBuilder(String name) {
        return new AggregatorBuilder(name);
    }

    private static SqlTypeName defaultTypeForFamily(SqlTypeFamily family) {
        switch (family) {
            case NUMERIC: 
            case APPROXIMATE_NUMERIC: {
                return SqlTypeName.DOUBLE;
            }
            case INTEGER: 
            case EXACT_NUMERIC: {
                return SqlTypeName.BIGINT;
            }
            case CHARACTER: {
                return SqlTypeName.VARCHAR;
            }
            case TIMESTAMP: {
                return SqlTypeName.TIMESTAMP;
            }
        }
        return (SqlTypeName)Iterables.getFirst((Iterable)family.getTypeNames(), (Object)SqlTypeName.NULL);
    }

    public static boolean throwOrReturn(boolean throwOnFailure, SqlCallBinding callBinding, Function<SqlCallBinding, CalciteException> exceptionMapper) {
        if (throwOnFailure) {
            throw exceptionMapper.apply(callBinding);
        }
        return false;
    }

    public static DirectOperatorConversion druidUnaryLongFn(String sqlOperator, String druidFunctionName) {
        return new DirectOperatorConversion((SqlOperator)OperatorConversions.operatorBuilder(sqlOperator).requiredOperandCount(1).operandTypes(SqlTypeFamily.NUMERIC).returnTypeNullable(SqlTypeName.BIGINT).functionCategory(SqlFunctionCategory.NUMERIC).build(), druidFunctionName);
    }

    public static DirectOperatorConversion druidBinaryLongFn(String sqlOperator, String druidFunctionName) {
        return new DirectOperatorConversion((SqlOperator)OperatorConversions.operatorBuilder(sqlOperator).requiredOperandCount(2).operandTypes(SqlTypeFamily.NUMERIC, SqlTypeFamily.NUMERIC).returnTypeNullable(SqlTypeName.BIGINT).functionCategory(SqlFunctionCategory.NUMERIC).build(), druidFunctionName);
    }

    public static DirectOperatorConversion druidUnaryDoubleFn(String sqlOperator, String druidFunctionName) {
        return new DirectOperatorConversion((SqlOperator)OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)sqlOperator)).requiredOperandCount(1).operandTypes(SqlTypeFamily.NUMERIC).returnTypeNullable(SqlTypeName.DOUBLE).functionCategory(SqlFunctionCategory.NUMERIC).build(), druidFunctionName);
    }

    public static class OperatorBuilder<T extends SqlFunction> {
        protected final String name;
        protected SqlKind kind = SqlKind.OTHER_FUNCTION;
        protected SqlReturnTypeInference returnTypeInference;
        protected SqlFunctionCategory functionCategory = SqlFunctionCategory.USER_DEFINED_FUNCTION;
        private SqlOperandTypeChecker operandTypeChecker;
        private List<String> operandNames = Collections.emptyList();
        private List<SqlTypeFamily> operandTypes;
        private Integer requiredOperandCount;
        private int[] literalOperands;
        private SqlOperandTypeInference operandTypeInference;

        private OperatorBuilder(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        }

        public OperatorBuilder<T> returnTypeNonNull(SqlTypeName typeName) {
            Preconditions.checkState((this.returnTypeInference == null ? 1 : 0) != 0, (Object)"Cannot set return type multiple times");
            this.returnTypeInference = ReturnTypes.explicit(factory -> Calcites.createSqlType(factory, typeName));
            return this;
        }

        public OperatorBuilder<T> returnTypeNullable(SqlTypeName typeName) {
            Preconditions.checkState((this.returnTypeInference == null ? 1 : 0) != 0, (Object)"Cannot set return type multiple times");
            this.returnTypeInference = ReturnTypes.explicit(factory -> Calcites.createSqlTypeWithNullability(factory, typeName, true));
            return this;
        }

        public OperatorBuilder<T> returnTypeCascadeNullable(SqlTypeName typeName) {
            Preconditions.checkState((this.returnTypeInference == null ? 1 : 0) != 0, (Object)"Cannot set return type multiple times");
            this.returnTypeInference = ReturnTypes.cascade((SqlReturnTypeInference)ReturnTypes.explicit((SqlTypeName)typeName), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.TO_NULLABLE});
            return this;
        }

        public OperatorBuilder<T> returnTypeArrayWithNullableElements(SqlTypeName elementTypeName) {
            Preconditions.checkState((this.returnTypeInference == null ? 1 : 0) != 0, (Object)"Cannot set return type multiple times");
            this.returnTypeInference = ReturnTypes.explicit(factory -> Calcites.createSqlArrayTypeWithNullability(factory, elementTypeName, true));
            return this;
        }

        public OperatorBuilder<T> returnTypeNullableArrayWithNullableElements(SqlTypeName elementTypeName) {
            this.returnTypeInference = ReturnTypes.cascade(opBinding -> Calcites.createSqlArrayTypeWithNullability(opBinding.getTypeFactory(), elementTypeName, true), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE});
            return this;
        }

        public OperatorBuilder<T> returnTypeInference(SqlReturnTypeInference returnTypeInference) {
            Preconditions.checkState((this.returnTypeInference == null ? 1 : 0) != 0, (Object)"Cannot set return type multiple times");
            this.returnTypeInference = returnTypeInference;
            return this;
        }

        public OperatorBuilder<T> functionCategory(SqlFunctionCategory functionCategory) {
            this.functionCategory = functionCategory;
            return this;
        }

        public OperatorBuilder<T> operandTypeChecker(SqlOperandTypeChecker operandTypeChecker) {
            this.operandTypeChecker = operandTypeChecker;
            return this;
        }

        public OperatorBuilder<T> operandNames(String ... operandNames) {
            this.operandNames = Arrays.asList(operandNames);
            return this;
        }

        public OperatorBuilder<T> operandTypes(SqlTypeFamily ... operandTypes) {
            this.operandTypes = Arrays.asList(operandTypes);
            return this;
        }

        public OperatorBuilder<T> requiredOperandCount(int requiredOperandCount) {
            this.requiredOperandCount = requiredOperandCount;
            return this;
        }

        @Deprecated
        public OperatorBuilder<T> requiredOperands(int requiredOperands) {
            return this.requiredOperandCount(requiredOperands);
        }

        public OperatorBuilder<T> literalOperands(int ... literalOperands) {
            this.literalOperands = literalOperands;
            return this;
        }

        public OperatorBuilder<T> operandTypeInference(SqlOperandTypeInference operandTypeInference) {
            this.operandTypeInference = operandTypeInference;
            return this;
        }

        public T build() {
            return (T)new SqlFunction(this.name, this.kind, (SqlReturnTypeInference)Preconditions.checkNotNull((Object)this.returnTypeInference, (Object)"returnTypeInference"), this.buildOperandTypeInference(), this.buildOperandTypeChecker(), this.functionCategory);
        }

        protected SqlOperandTypeChecker buildOperandTypeChecker() {
            if (this.operandTypeChecker == null) {
                if (this.operandTypes == null) {
                    throw DruidException.defensive((String)"'operandTypes' must be non null if 'operandTypeChecker' is not passed to the operator conversion.", (Object[])new Object[0]);
                }
                return DefaultOperandTypeChecker.builder().operandNames(this.operandNames).operandTypes(this.operandTypes).requiredOperandCount(this.requiredOperandCount == null ? this.operandTypes.size() : this.requiredOperandCount.intValue()).literalOperands(this.literalOperands).build();
            }
            if (this.operandNames.isEmpty() && this.operandTypes == null && this.requiredOperandCount == null && this.literalOperands == null) {
                return this.operandTypeChecker;
            }
            throw new ISE("Cannot have both 'operandTypeChecker' and 'operandNames' / 'operandTypes' / 'requiredOperands' / 'literalOperands'", new Object[0]);
        }

        protected SqlOperandTypeInference buildOperandTypeInference() {
            IntArraySet nullableOperands;
            Object object = nullableOperands = this.requiredOperandCount == null ? new IntArraySet() : DefaultOperandTypeChecker.buildNullableOperands(this.requiredOperandCount, this.operandTypes.size(), (IntSet)new IntArraySet());
            if (this.operandTypeInference == null) {
                DefaultOperandTypeInference defaultInference = new DefaultOperandTypeInference(this.operandTypes, (IntSet)nullableOperands);
                return (callBinding, returnType, types) -> {
                    for (int i = 0; i < types.length; ++i) {
                        if (callBinding.operand(i).isA((Set)ImmutableSet.of((Object)SqlKind.DYNAMIC_PARAM))) {
                            types[i] = new BasicSqlType((RelDataTypeSystem)DruidTypeSystem.INSTANCE, SqlTypeName.ANY);
                            continue;
                        }
                        defaultInference.inferOperandTypes(callBinding, returnType, types);
                    }
                };
            }
            return this.operandTypeInference;
        }
    }

    public static class AggregatorBuilder
    extends OperatorBuilder<SqlAggFunction> {
        public AggregatorBuilder(String name) {
            super(name);
        }

        @Override
        public SqlAggFunction build() {
            final SqlOperandTypeInference operandTypeInference = this.buildOperandTypeInference();
            final SqlOperandTypeChecker operandTypeChecker = this.buildOperandTypeChecker();
            class DruidSqlAggFunction
            extends SqlAggFunction {
                public DruidSqlAggFunction() {
                    super(AggregatorBuilder.this.name, null, AggregatorBuilder.this.kind, AggregatorBuilder.this.returnTypeInference, sqlOperandTypeInference, sqlOperandTypeChecker, AggregatorBuilder.this.functionCategory, false, false, Optionality.FORBIDDEN);
                }
            }
            return new DruidSqlAggFunction();
        }
    }

    private static class DefaultOperandTypeInference
    implements SqlOperandTypeInference {
        private final List<SqlTypeFamily> operandTypes;
        private final IntSet nullableOperands;

        DefaultOperandTypeInference(List<SqlTypeFamily> operandTypes, IntSet nullableOperands) {
            this.operandTypes = operandTypes;
            this.nullableOperands = nullableOperands;
        }

        public void inferOperandTypes(SqlCallBinding callBinding, RelDataType returnType, RelDataType[] operandTypesOut) {
            for (int i = 0; i < operandTypesOut.length; ++i) {
                RelDataType derivedType = callBinding.getValidator().deriveType(callBinding.getScope(), callBinding.operand(i));
                RelDataType inferredType = derivedType.getSqlTypeName() != SqlTypeName.NULL ? derivedType : (this.nullableOperands.contains(i) ? Calcites.createSqlTypeWithNullability(callBinding.getTypeFactory(), OperatorConversions.defaultTypeForFamily(this.operandTypes.get(i)), true) : callBinding.getValidator().getUnknownType());
                operandTypesOut[i] = inferredType;
            }
        }
    }
}

