/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlJsonEmptyOrError;
import org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.nested.NestedPathFinder;
import org.apache.druid.segment.nested.NestedPathPart;
import org.apache.druid.segment.virtual.NestedFieldVirtualColumn;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.convertlet.DruidConvertletFactory;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class NestedDataOperatorConversions {
    public static final DruidJsonValueConvertletFactory DRUID_JSON_VALUE_CONVERTLET_FACTORY_INSTANCE = new DruidJsonValueConvertletFactory();
    public static final SqlReturnTypeInference NESTED_RETURN_TYPE_INFERENCE = opBinding -> RowSignatures.makeComplexType(opBinding.getTypeFactory(), ColumnType.NESTED_DATA, true);
    public static final SqlReturnTypeInference NESTED_ARRAY_RETURN_TYPE_INFERENCE = opBinding -> opBinding.getTypeFactory().createArrayType(RowSignatures.makeComplexType(opBinding.getTypeFactory(), ColumnType.NESTED_DATA, true), -1L);

    @Nonnull
    private static List<NestedPathPart> extractNestedPathParts(RexCall call, String path) {
        try {
            return NestedPathFinder.parseJsonPath((String)path);
        }
        catch (IllegalArgumentException iae) {
            String name = call.getOperator().getName();
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build((Throwable)iae, "Error when processing path [%s], operator [%s] is not useable", new Object[]{path, name});
        }
    }

    public static class DruidJsonValueConvertletFactory
    implements DruidConvertletFactory {
        @Override
        public SqlRexConvertlet createConvertlet(PlannerContext plannerContext) {
            return (cx, call) -> {
                SqlFunction jsonValueOperator;
                for (int i = 2; i < call.operandCount(); ++i) {
                    SqlNode operand = call.operand(i);
                    if (operand.getKind() != SqlKind.LITERAL || !(((SqlLiteral)operand).getValue() instanceof SqlJsonEmptyOrError)) continue;
                    SqlNode priorOperand = call.operand(i - 1);
                    Preconditions.checkArgument((priorOperand.getKind() == SqlKind.LITERAL && ((SqlLiteral)priorOperand).getValue() == SqlJsonValueEmptyOrErrorBehavior.NULL ? 1 : 0) != 0, (String)"Unsupported JSON_VALUE parameter '%s' defined - please re-issue this query without this argument", (Object)((SqlLiteral)operand).getValue());
                }
                RelDataType sqlType = cx.getValidator().getValidatedNodeType((SqlNode)call);
                if (SqlTypeName.INT_TYPES.contains(sqlType.getSqlTypeName())) {
                    jsonValueOperator = JsonValueBigintOperatorConversion.FUNCTION;
                } else if (SqlTypeName.DECIMAL.equals((Object)sqlType.getSqlTypeName()) || SqlTypeName.APPROX_TYPES.contains(sqlType.getSqlTypeName())) {
                    jsonValueOperator = JsonValueDoubleOperatorConversion.FUNCTION;
                } else if (SqlTypeName.STRING_TYPES.contains(sqlType.getSqlTypeName())) {
                    jsonValueOperator = JsonValueVarcharOperatorConversion.FUNCTION;
                } else if (SqlTypeName.ARRAY.equals((Object)sqlType.getSqlTypeName())) {
                    ColumnType elementType = Calcites.getColumnTypeForRelDataType(sqlType.getComponentType());
                    switch ((ValueType)elementType.getType()) {
                        case LONG: {
                            jsonValueOperator = JsonValueReturningArrayBigIntOperatorConversion.FUNCTION;
                            break;
                        }
                        case DOUBLE: {
                            jsonValueOperator = JsonValueReturningArrayDoubleOperatorConversion.FUNCTION;
                            break;
                        }
                        case STRING: {
                            jsonValueOperator = JsonValueReturningArrayVarcharOperatorConversion.FUNCTION;
                            break;
                        }
                        default: {
                            throw new IAE("Unhandled JSON_VALUE RETURNING ARRAY type [%s]", new Object[]{sqlType.getComponentType()});
                        }
                    }
                } else {
                    jsonValueOperator = JsonValueAnyOperatorConversion.FUNCTION;
                }
                return cx.getRexBuilder().makeCast(sqlType, cx.getRexBuilder().makeCall((SqlOperator)jsonValueOperator, new RexNode[]{cx.convertExpression(call.operand(0)), cx.convertExpression(call.operand(1))}));
            };
        }

        @Override
        public List<SqlOperator> operators() {
            return Collections.singletonList(SqlStdOperatorTable.JSON_VALUE);
        }
    }

    public static class TryParseJsonOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "try_parse_json";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"try_parse_json")).operandTypes(SqlTypeFamily.STRING).returnTypeInference(NESTED_RETURN_TYPE_INFERENCE).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(ColumnType.NESTED_DATA, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions));
        }
    }

    public static class ParseJsonOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "parse_json";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"parse_json")).operandTypes(SqlTypeFamily.STRING).returnTypeInference(NESTED_RETURN_TYPE_INFERENCE).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(ColumnType.NESTED_DATA, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions));
        }
    }

    public static class ToJsonStringOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "to_json_string";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"to_json_string")).operandTypes(SqlTypeFamily.ANY).returnTypeCascadeNullable(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(ColumnType.NESTED_DATA, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions));
        }
    }

    public static class JsonMergeOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "json_merge";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("json_merge").operandTypeChecker(OperandTypes.variadic((SqlOperandCountRange)SqlOperandCountRanges.from((int)1))).operandTypeInference((callBinding, returnType, operandTypes) -> {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
            }
        }).returnTypeInference(NESTED_RETURN_TYPE_INFERENCE).functionCategory(SqlFunctionCategory.SYSTEM).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(ColumnType.NESTED_DATA, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions));
        }
    }

    public static class JsonObjectOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "json_object";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"json_object")).operandTypeChecker(OperandTypes.variadic((SqlOperandCountRange)SqlOperandCountRanges.from((int)1))).operandTypeInference((callBinding, returnType, operandTypes) -> {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            for (int i = 0; i < operandTypes.length; ++i) {
                operandTypes[i] = i % 2 == 0 ? typeFactory.createSqlType(SqlTypeName.VARCHAR) : typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
            }
        }).returnTypeInference(NESTED_RETURN_TYPE_INFERENCE).functionCategory(SqlFunctionCategory.SYSTEM).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            DruidExpression.DruidExpressionCreator expressionFunction = druidExpressions -> DruidExpression.ofExpression(ColumnType.NESTED_DATA, null, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions);
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions2 = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands().subList(1, call.getOperands().size()));
            if (druidExpressions2 == null) {
                return null;
            }
            return expressionFunction.create(druidExpressions2);
        }
    }

    public static class JsonValueAnyOperatorConversion
    implements SqlOperatorConversion {
        private static final SqlFunction FUNCTION = OperatorConversions.operatorBuilder("JSON_VALUE_ANY").operandTypeChecker(OperandTypes.or((SqlOperandTypeChecker[])new SqlOperandTypeChecker[]{OperandTypes.sequence((String)"'JSON_VALUE_ANY(expr, path)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY})})).operandTypeInference((callBinding, returnType, operandTypes) -> {
            RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
            if (operandTypes.length > 5) {
                operandTypes[3] = typeFactory.createSqlType(SqlTypeName.ANY);
                operandTypes[5] = typeFactory.createSqlType(SqlTypeName.ANY);
            }
        }).returnTypeInference((SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> opBinding.getTypeFactory().createTypeWithNullability(opBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR), true), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE})).functionCategory(SqlFunctionCategory.SYSTEM).build();

        @Override
        public SqlOperator calciteOperator() {
            return FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands().size() > 2 ? call.getOperands().subList(0, 2) : call.getOperands());
            if (druidExpressions == null || druidExpressions.size() != 2) {
                return null;
            }
            Expr pathExpr = plannerContext.parseExpression(druidExpressions.get(1).getExpression());
            if (!pathExpr.isLiteral()) {
                return null;
            }
            String path = (String)pathExpr.eval(InputBindings.nilBindings()).value();
            List<NestedPathPart> parts = NestedDataOperatorConversions.extractNestedPathParts(call, path);
            String jsonPath = NestedPathFinder.toNormalizedJsonPath(parts);
            DruidExpression.ExpressionGenerator builder = args -> "json_value(" + ((DruidExpression)args.get(0)).getExpression() + ",'" + jsonPath + "')";
            ColumnType columnType = ColumnType.STRING;
            if (druidExpressions.get(0).isSimpleExtraction()) {
                return DruidExpression.ofVirtualColumn(columnType, builder, (List<DruidExpression>)ImmutableList.of((Object)DruidExpression.ofColumn(ColumnType.NESTED_DATA, druidExpressions.get(0).getDirectColumn())), (name, outputType, expression, macroTable) -> new NestedFieldVirtualColumn(((DruidExpression)druidExpressions.get(0)).getDirectColumn(), name, null, parts, Boolean.valueOf(false), null, null));
            }
            return DruidExpression.ofExpression(columnType, builder, druidExpressions);
        }
    }

    public static class JsonValueReturningArrayVarcharOperatorConversion
    extends JsonValueReturningArrayTypeOperatorConversion {
        static final SqlFunction FUNCTION = JsonValueReturningArrayVarcharOperatorConversion.buildArrayFunction("JSON_VALUE_ARRAY_VARCHAR", SqlTypeName.VARCHAR);

        public JsonValueReturningArrayVarcharOperatorConversion() {
            super(FUNCTION, ColumnType.STRING_ARRAY);
        }
    }

    public static class JsonValueReturningArrayDoubleOperatorConversion
    extends JsonValueReturningArrayTypeOperatorConversion {
        static final SqlFunction FUNCTION = JsonValueReturningArrayDoubleOperatorConversion.buildArrayFunction("JSON_VALUE_ARRAY_DOUBLE", SqlTypeName.DOUBLE);

        public JsonValueReturningArrayDoubleOperatorConversion() {
            super(FUNCTION, ColumnType.DOUBLE_ARRAY);
        }
    }

    public static class JsonValueReturningArrayBigIntOperatorConversion
    extends JsonValueReturningArrayTypeOperatorConversion {
        static final SqlFunction FUNCTION = JsonValueReturningArrayBigIntOperatorConversion.buildArrayFunction("JSON_VALUE_ARRAY_BIGINT", SqlTypeName.BIGINT);

        public JsonValueReturningArrayBigIntOperatorConversion() {
            super(FUNCTION, ColumnType.LONG_ARRAY);
        }
    }

    public static abstract class JsonValueReturningArrayTypeOperatorConversion
    implements SqlOperatorConversion {
        private final SqlFunction function;
        private final ColumnType druidType;

        public JsonValueReturningArrayTypeOperatorConversion(SqlFunction function, ColumnType druidType) {
            this.druidType = druidType;
            this.function = function;
        }

        @Override
        public SqlOperator calciteOperator() {
            return this.function;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            List parts;
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands());
            if (druidExpressions == null || druidExpressions.size() != 2) {
                return null;
            }
            Expr pathExpr = plannerContext.parseExpression(druidExpressions.get(1).getExpression());
            if (!pathExpr.isLiteral()) {
                return null;
            }
            String path = (String)pathExpr.eval(InputBindings.nilBindings()).value();
            try {
                parts = NestedPathFinder.parseJsonPath((String)path);
            }
            catch (IllegalArgumentException iae) {
                throw InvalidSqlInput.exception((String)"Cannot use [%s]: [%s]", (Object[])new Object[]{call.getOperator().getName(), iae.getMessage()});
            }
            String jsonPath = NestedPathFinder.toNormalizedJsonPath((List)parts);
            DruidExpression.ExpressionGenerator builder = args -> "json_value(" + ((DruidExpression)args.get(0)).getExpression() + ",'" + jsonPath + "', '" + this.druidType.asTypeString() + "')";
            if (druidExpressions.get(0).isSimpleExtraction()) {
                return DruidExpression.ofVirtualColumn(this.druidType, builder, (List<DruidExpression>)ImmutableList.of((Object)DruidExpression.ofColumn(ColumnType.NESTED_DATA, druidExpressions.get(0).getDirectColumn())), (name, outputType, expression, macroTable) -> new NestedFieldVirtualColumn(((DruidExpression)druidExpressions.get(0)).getDirectColumn(), name, outputType, parts, Boolean.valueOf(false), null, null));
            }
            return DruidExpression.ofExpression(this.druidType, builder, druidExpressions);
        }

        static SqlFunction buildArrayFunction(String functionName, SqlTypeName elementTypeName) {
            return OperatorConversions.operatorBuilder(functionName).operandTypeChecker(OperandTypes.sequence((String)("'" + functionName + "(expr, path)'"), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})).returnTypeInference(opBinding -> opBinding.getTypeFactory().createTypeWithNullability(Calcites.createSqlArrayTypeWithNullability(opBinding.getTypeFactory(), elementTypeName, false), true)).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();
        }
    }

    public static class JsonValueVarcharOperatorConversion
    extends JsonValueReturningTypeOperatorConversion {
        private static final SqlFunction FUNCTION = JsonValueVarcharOperatorConversion.buildFunction("JSON_VALUE_VARCHAR", SqlTypeName.VARCHAR);

        public JsonValueVarcharOperatorConversion() {
            super(FUNCTION, ColumnType.STRING);
        }
    }

    public static class JsonValueDoubleOperatorConversion
    extends JsonValueReturningTypeOperatorConversion {
        private static final SqlFunction FUNCTION = JsonValueDoubleOperatorConversion.buildFunction("JSON_VALUE_DOUBLE", SqlTypeName.DOUBLE);

        public JsonValueDoubleOperatorConversion() {
            super(FUNCTION, ColumnType.DOUBLE);
        }
    }

    public static class JsonValueBigintOperatorConversion
    extends JsonValueReturningTypeOperatorConversion {
        private static final SqlFunction FUNCTION = JsonValueBigintOperatorConversion.buildFunction("JSON_VALUE_BIGINT", SqlTypeName.BIGINT);

        public JsonValueBigintOperatorConversion() {
            super(FUNCTION, ColumnType.LONG);
        }
    }

    public static abstract class JsonValueReturningTypeOperatorConversion
    implements SqlOperatorConversion {
        private final SqlFunction function;
        private final ColumnType druidType;

        public JsonValueReturningTypeOperatorConversion(SqlFunction function, ColumnType druidType) {
            this.druidType = druidType;
            this.function = function;
        }

        @Override
        public SqlOperator calciteOperator() {
            return this.function;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands());
            if (druidExpressions == null || druidExpressions.size() != 2) {
                return null;
            }
            Expr pathExpr = plannerContext.parseExpression(druidExpressions.get(1).getExpression());
            if (!pathExpr.isLiteral()) {
                return DruidExpression.ofFunctionCall(this.druidType, "json_value", (List<DruidExpression>)ImmutableList.builder().addAll(druidExpressions).add((Object)DruidExpression.ofStringLiteral(this.druidType.asTypeString())).build());
            }
            String path = (String)pathExpr.eval(InputBindings.nilBindings()).value();
            List<NestedPathPart> parts = NestedDataOperatorConversions.extractNestedPathParts(call, path);
            String jsonPath = NestedPathFinder.toNormalizedJsonPath(parts);
            DruidExpression.ExpressionGenerator builder = args -> "json_value(" + ((DruidExpression)args.get(0)).getExpression() + ",'" + jsonPath + "', '" + this.druidType.asTypeString() + "')";
            if (druidExpressions.get(0).isSimpleExtraction()) {
                return DruidExpression.ofVirtualColumn(this.druidType, builder, (List<DruidExpression>)ImmutableList.of((Object)DruidExpression.ofColumn(ColumnType.NESTED_DATA, druidExpressions.get(0).getDirectColumn())), (name, outputType, expression, macroTable) -> new NestedFieldVirtualColumn(((DruidExpression)druidExpressions.get(0)).getDirectColumn(), name, outputType, parts, Boolean.valueOf(false), null, null));
            }
            return DruidExpression.ofExpression(this.druidType, builder, druidExpressions);
        }

        static SqlFunction buildFunction(String functionName, SqlTypeName typeName) {
            return OperatorConversions.operatorBuilder(functionName).operandTypeChecker(OperandTypes.sequence((String)("'" + functionName + "(expr, path)'"), (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.STRING})})).returnTypeInference((SqlReturnTypeInference)ReturnTypes.cascade(opBinding -> opBinding.getTypeFactory().createSqlType(typeName), (SqlTypeTransform[])new SqlTypeTransform[]{SqlTypeTransforms.FORCE_NULLABLE})).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).build();
        }
    }

    public static class JsonQueryArrayOperatorConversion
    extends DirectOperatorConversion {
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"json_query_array")).operandTypeChecker((SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER})).returnTypeInference(NESTED_ARRAY_RETURN_TYPE_INFERENCE.andThen(SqlTypeTransforms.FORCE_NULLABLE)).functionCategory(SqlFunctionCategory.SYSTEM).build();

        public JsonQueryArrayOperatorConversion() {
            super((SqlOperator)SQL_FUNCTION, "json_query_array");
        }
    }

    public static class JsonQueryOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "json_query";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"json_query")).operandTypeChecker((SqlOperandTypeChecker)OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.CHARACTER, SqlTypeFamily.ANY, SqlTypeFamily.ANY, SqlTypeFamily.ANY})).returnTypeInference(NESTED_RETURN_TYPE_INFERENCE).functionCategory(SqlFunctionCategory.SYSTEM).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            RexCall call = (RexCall)rexNode;
            List<DruidExpression> druidExpressions = Expressions.toDruidExpressions(plannerContext, rowSignature, call.getOperands().subList(0, 2));
            if (druidExpressions == null || druidExpressions.size() != 2) {
                return null;
            }
            Expr pathExpr = plannerContext.parseExpression(druidExpressions.get(1).getExpression());
            if (!pathExpr.isLiteral()) {
                return DruidExpression.ofFunctionCall(ColumnType.NESTED_DATA, FUNCTION_NAME, druidExpressions);
            }
            String path = (String)pathExpr.eval(InputBindings.nilBindings()).value();
            List<NestedPathPart> parts = NestedDataOperatorConversions.extractNestedPathParts(call, path);
            String jsonPath = NestedPathFinder.toNormalizedJsonPath(parts);
            DruidExpression.ExpressionGenerator builder = args -> "json_query(" + ((DruidExpression)args.get(0)).getExpression() + ",'" + jsonPath + "')";
            if (druidExpressions.get(0).isSimpleExtraction()) {
                return DruidExpression.ofVirtualColumn(ColumnType.NESTED_DATA, builder, (List<DruidExpression>)ImmutableList.of((Object)DruidExpression.ofColumn(ColumnType.NESTED_DATA, druidExpressions.get(0).getDirectColumn())), (name, outputType, expression, macroTable) -> new NestedFieldVirtualColumn(((DruidExpression)druidExpressions.get(0)).getDirectColumn(), name, outputType, parts, Boolean.valueOf(true), null, null));
            }
            return DruidExpression.ofExpression(ColumnType.NESTED_DATA, builder, druidExpressions);
        }
    }

    public static class JsonKeysOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "json_keys";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"json_keys")).operandNames("expr", "path").operandTypes(SqlTypeFamily.ANY, SqlTypeFamily.STRING).literalOperands(1).requiredOperandCount(2).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).returnTypeNullableArrayWithNullableElements(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(ColumnType.STRING_ARRAY, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions));
        }
    }

    public static class JsonPathsOperatorConversion
    implements SqlOperatorConversion {
        private static final String FUNCTION_NAME = "json_paths";
        private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder(StringUtils.toUpperCase((String)"json_paths")).operandTypeChecker((SqlOperandTypeChecker)OperandTypes.ANY).functionCategory(SqlFunctionCategory.USER_DEFINED_FUNCTION).returnTypeArrayWithNullableElements(SqlTypeName.VARCHAR).build();

        @Override
        public SqlOperator calciteOperator() {
            return SQL_FUNCTION;
        }

        @Override
        @Nullable
        public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
            return OperatorConversions.convertCall(plannerContext, rowSignature, rexNode, druidExpressions -> DruidExpression.ofExpression(null, DruidExpression.functionCall(FUNCTION_NAME), druidExpressions));
        }
    }
}

