/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.regex.PatternSyntaxException;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.RegexDimExtractionFn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class RegexpExtractOperatorConversion
implements SqlOperatorConversion {
    private static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("REGEXP_EXTRACT").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.INTEGER).requiredOperandCount(2).literalOperands(1, 2).returnTypeNullable(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.STRING).build();
    private static final int DEFAULT_INDEX = 0;

    public SqlFunction calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertDirectCallWithExtraction(plannerContext, rowSignature, rexNode, StringUtils.toLowerCase((String)this.calciteOperator().getName()), inputExpressions -> {
            Expr indexExpr;
            DruidExpression arg = (DruidExpression)inputExpressions.get(0);
            Expr patternExpr = plannerContext.parseExpression(((DruidExpression)inputExpressions.get(1)).getExpression());
            Expr expr = indexExpr = inputExpressions.size() > 2 ? plannerContext.parseExpression(((DruidExpression)inputExpressions.get(2)).getExpression()) : null;
            if (arg.isSimpleExtraction() && patternExpr.isLiteral() && (indexExpr == null || indexExpr.isLiteral())) {
                String pattern = (String)patternExpr.getLiteralValue();
                try {
                    return arg.getSimpleExtraction().cascade((ExtractionFn)new RegexDimExtractionFn(StringUtils.nullToEmptyNonDruidDataString((String)pattern), Integer.valueOf(indexExpr == null ? 0 : ((Number)indexExpr.getLiteralValue()).intValue()), Boolean.valueOf(true), null));
                }
                catch (PatternSyntaxException e) {
                    throw InvalidSqlInput.exception((Throwable)e, (String)StringUtils.format((String)"An invalid pattern [%s] was provided for the REGEXP_EXTRACT function, error: [%s]", (Object[])new Object[]{e.getPattern(), e.getMessage()}), (Object[])new Object[0]);
                }
            }
            return null;
        });
    }
}

