/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.query.filter.TypedInFilter;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DirectOperatorConversion;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.DruidLiteral;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class ScalarInArrayOperatorConversion
extends DirectOperatorConversion {
    public static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("SCALAR_IN_ARRAY").operandTypeChecker(OperandTypes.sequence((String)"'SCALAR_IN_ARRAY(expr, array)'", (SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.or((SqlSingleOperandTypeChecker[])new SqlSingleOperandTypeChecker[]{OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.CHARACTER}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.NUMERIC})}), OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY})})).returnTypeInference(ReturnTypes.BOOLEAN_NULLABLE).build();

    public ScalarInArrayOperatorConversion() {
        super((SqlOperator)SQL_FUNCTION, "scalar_in_array");
    }

    @Override
    @Nullable
    public DimFilter toDruidFilter(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexNode rexNode) {
        ExtractionFn scalarExtractionFn;
        String scalarColumn;
        RexCall call = (RexCall)rexNode;
        RexNode scalarOperand = (RexNode)call.getOperands().get(0);
        RexNode arrayOperand = (RexNode)call.getOperands().get(1);
        DruidExpression scalarExpression = Expressions.toDruidExpression(plannerContext, rowSignature, scalarOperand);
        if (scalarExpression == null) {
            return null;
        }
        if (scalarExpression.isDirectColumnAccess()) {
            scalarColumn = scalarExpression.getDirectColumn();
            scalarExtractionFn = null;
        } else if (scalarExpression.isSimpleExtraction() && plannerContext.isUseLegacyInFilter()) {
            scalarColumn = scalarExpression.getSimpleExtraction().getColumn();
            scalarExtractionFn = scalarExpression.getSimpleExtraction().getExtractionFn();
        } else {
            if (virtualColumnRegistry == null) {
                return null;
            }
            scalarColumn = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(scalarExpression, scalarExpression.getDruidType());
            scalarExtractionFn = null;
        }
        if (Calcites.isLiteral(arrayOperand, true, true)) {
            RelDataType elementType = arrayOperand.getType().getComponentType();
            List arrayElements = ((RexCall)arrayOperand).getOperands();
            ArrayList<Object> arrayElementLiteralValues = new ArrayList<Object>(arrayElements.size());
            for (RexNode arrayElement : arrayElements) {
                DruidLiteral arrayElementEval = Expressions.calciteLiteralToDruidLiteral(plannerContext, arrayElement);
                if (arrayElementEval == null) {
                    return null;
                }
                arrayElementLiteralValues.add(arrayElementEval.value());
            }
            return ScalarInArrayOperatorConversion.makeInFilter(plannerContext, scalarColumn, scalarExtractionFn, arrayElementLiteralValues, Calcites.getColumnTypeForRelDataType(elementType));
        }
        return null;
    }

    public static DimFilter makeInFilter(PlannerContext plannerContext, String columnName, @Nullable ExtractionFn extractionFn, List<Object> matchValues, ColumnType matchValueType) {
        if (plannerContext.isUseLegacyInFilter() || extractionFn != null) {
            InDimFilter.ValuesSet valuesSet = InDimFilter.ValuesSet.create();
            for (Object matchValue : matchValues) {
                valuesSet.add(Evals.asString((Object)matchValue));
            }
            return new InDimFilter(columnName, valuesSet, extractionFn, null);
        }
        return new TypedInFilter(columnName, matchValueType, matchValues, null, null);
    }
}

