/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.FunctionExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.util.NlsString;
import org.apache.druid.java.util.common.IAE;

public class BaseUserDefinedTableMacro
extends SqlUserDefinedTableMacro {
    protected final TableMacro macro;

    public BaseUserDefinedTableMacro(SqlIdentifier opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandMetadata operandMetadata, TableMacro tableMacro) {
        super(opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandMetadata, tableMacro);
        this.macro = tableMacro;
    }

    public TranslatableTable getTable(SqlOperatorBinding callBinding) {
        List<Object> arguments = BaseUserDefinedTableMacro.convertArguments(callBinding, (Function)this.macro, this.getNameAsId(), true);
        return this.macro.apply(arguments);
    }

    public static List<Object> convertArguments(SqlOperatorBinding callBinding, Function function, SqlIdentifier opName, boolean failOnNonLiteral) {
        RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
        List parameters = function.getParameters();
        ArrayList<Object> arguments = new ArrayList<Object>(callBinding.getOperandCount());
        for (int i = 0; i < parameters.size(); ++i) {
            FunctionParameter parameter = (FunctionParameter)parameters.get(i);
            RelDataType type = parameter.getType(typeFactory);
            try {
                if (!callBinding.isOperandLiteral(i, true)) {
                    throw new NonLiteralException();
                }
                Object o = callBinding.getOperandLiteralValue(i, Object.class);
                Object o2 = BaseUserDefinedTableMacro.coerce(o, type);
                arguments.add(o2);
                continue;
            }
            catch (NonLiteralException e) {
                if (failOnNonLiteral) {
                    throw new IAE("All arguments of call to macro %s should be literal. Actual argument #%d (%s) is not literal", new Object[]{opName, parameter.getOrdinal(), parameter.getName()});
                }
                Long value = type.isNullable() ? null : Long.valueOf(0L);
                arguments.add(value);
            }
        }
        return arguments;
    }

    private static Object coerce(Object o, RelDataType type) throws NonLiteralException {
        if (o == null) {
            return null;
        }
        if (type instanceof ArraySqlType) {
            RelDataType elementType = ((ArraySqlType)type).getComponentType();
            if (!(elementType instanceof RelDataTypeFactoryImpl.JavaType)) {
                throw new NonLiteralException();
            }
            if (!(o instanceof List)) {
                throw new NonLiteralException();
            }
            List arg = (List)o;
            ArrayList<Object> revised = new ArrayList<Object>(arg.size());
            for (Object value : arg) {
                Object element = BaseUserDefinedTableMacro.coerce(value, elementType);
                if (element == null) {
                    throw new NonLiteralException();
                }
                revised.add(element);
            }
            return revised;
        }
        if (!(type instanceof RelDataTypeFactoryImpl.JavaType)) {
            throw new NonLiteralException();
        }
        RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type;
        Class clazz = javaType.getJavaClass();
        if (clazz.isAssignableFrom(o.getClass())) {
            return o;
        }
        if (clazz == String.class && o instanceof NlsString) {
            return ((NlsString)o).getValue();
        }
        BlockBuilder bb = new BlockBuilder();
        Expression expr = EnumUtils.convert((Expression)Expressions.constant((Object)o), (Type)clazz);
        bb.add((Statement)Expressions.return_(null, (Expression)expr));
        FunctionExpression convert = Expressions.lambda((BlockStatement)bb.toBlock(), Collections.emptyList());
        return convert.compile().dynamicInvoke(new Object[0]);
    }

    private static class NonLiteralException
    extends Exception {
        private NonLiteralException() {
        }
    }
}

