/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlInternalOperator;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlCollectionTableOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.sql.calcite.external.SchemaAwareUserDefinedTableMacro;

public class ExtendOperator
extends SqlInternalOperator {
    public static final ExtendOperator EXTEND = new ExtendOperator();

    ExtendOperator() {
        super("EXTEND", SqlKind.EXTEND, 200);
    }

    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        SqlBasicCall tableOpCall = (SqlBasicCall)call.operand(0);
        if (!(tableOpCall.getOperator() instanceof SqlCollectionTableOperator)) {
            throw new ISE("First argument to EXTEND must be TABLE", new Object[0]);
        }
        SqlBasicCall tableFnCall = (SqlBasicCall)tableOpCall.operand(0);
        if (!(tableFnCall.getOperator() instanceof SchemaAwareUserDefinedTableMacro)) {
            throw new IAE("Function %s does not accept an EXTEND clause (or a schema list)", new Object[]{tableFnCall.getOperator().getName()});
        }
        SchemaAwareUserDefinedTableMacro tableFn = (SchemaAwareUserDefinedTableMacro)tableFnCall.getOperator();
        SqlNodeList schema = (SqlNodeList)call.operand(1);
        SqlBasicCall newCall = tableFn.rewriteCall(tableFnCall, schema);
        return SqlStdOperatorTable.COLLECTION_TABLE.createCall(call.getParserPosition(), new SqlNode[]{newCall});
    }
}

