/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.base.Function;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.sql.calcite.filtration.BoundRefKey;
import org.apache.druid.sql.calcite.filtration.BoundValue;
import org.joda.time.Interval;

public class Bounds {
    public static BoundDimFilter not(BoundDimFilter bound) {
        if (bound.getUpper() != null && bound.getLower() != null) {
            return null;
        }
        if (bound.getUpper() != null) {
            return new BoundDimFilter(bound.getDimension(), bound.getUpper(), null, Boolean.valueOf(!bound.isUpperStrict()), Boolean.valueOf(false), null, bound.getExtractionFn(), bound.getOrdering(), bound.getFilterTuning());
        }
        return new BoundDimFilter(bound.getDimension(), null, bound.getLower(), Boolean.valueOf(false), Boolean.valueOf(!bound.isLowerStrict()), null, bound.getExtractionFn(), bound.getOrdering(), bound.getFilterTuning());
    }

    public static Range<BoundValue> toRange(BoundDimFilter bound) {
        BoundValue lower;
        BoundValue upper = bound.getUpper() != null ? new BoundValue(bound.getUpper(), bound.getOrdering()) : null;
        BoundValue boundValue = lower = bound.getLower() != null ? new BoundValue(bound.getLower(), bound.getOrdering()) : null;
        if (lower == null) {
            return bound.isUpperStrict() ? Range.lessThan((Comparable)upper) : Range.atMost((Comparable)upper);
        }
        if (upper == null) {
            return bound.isLowerStrict() ? Range.greaterThan((Comparable)lower) : Range.atLeast((Comparable)lower);
        }
        BoundType lowerBoundType = bound.isLowerStrict() ? BoundType.OPEN : BoundType.CLOSED;
        BoundType upperBoundType = bound.isUpperStrict() ? BoundType.OPEN : BoundType.CLOSED;
        return Range.range((Comparable)lower, (BoundType)lowerBoundType, (Comparable)upper, (BoundType)upperBoundType);
    }

    public static List<Range<BoundValue>> toRanges(List<BoundDimFilter> bounds) {
        return ImmutableList.copyOf((Collection)Lists.transform(bounds, (Function)new Function<BoundDimFilter, Range<BoundValue>>(){

            public Range<BoundValue> apply(BoundDimFilter bound) {
                return Bounds.toRange(bound);
            }
        }));
    }

    public static BoundDimFilter toFilter(BoundRefKey boundRefKey, Range<BoundValue> range) {
        return new BoundDimFilter(boundRefKey.getDimension(), range.hasLowerBound() ? ((BoundValue)range.lowerEndpoint()).getValue() : null, range.hasUpperBound() ? ((BoundValue)range.upperEndpoint()).getValue() : null, Boolean.valueOf(range.hasLowerBound() && range.lowerBoundType() == BoundType.OPEN), Boolean.valueOf(range.hasUpperBound() && range.upperBoundType() == BoundType.OPEN), null, boundRefKey.getExtractionFn(), boundRefKey.getComparator(), null);
    }

    public static BoundDimFilter equalTo(BoundRefKey boundRefKey, String value) {
        return new BoundDimFilter(boundRefKey.getDimension(), value, value, Boolean.valueOf(false), Boolean.valueOf(false), null, boundRefKey.getExtractionFn(), boundRefKey.getComparator(), null);
    }

    public static BoundDimFilter greaterThan(BoundRefKey boundRefKey, String value) {
        return new BoundDimFilter(boundRefKey.getDimension(), value, null, Boolean.valueOf(true), Boolean.valueOf(false), null, boundRefKey.getExtractionFn(), boundRefKey.getComparator(), null);
    }

    public static BoundDimFilter greaterThanOrEqualTo(BoundRefKey boundRefKey, String value) {
        return new BoundDimFilter(boundRefKey.getDimension(), value, null, Boolean.valueOf(false), Boolean.valueOf(false), null, boundRefKey.getExtractionFn(), boundRefKey.getComparator(), null);
    }

    public static BoundDimFilter lessThan(BoundRefKey boundRefKey, String value) {
        return new BoundDimFilter(boundRefKey.getDimension(), null, value, Boolean.valueOf(false), Boolean.valueOf(true), null, boundRefKey.getExtractionFn(), boundRefKey.getComparator(), null);
    }

    public static BoundDimFilter lessThanOrEqualTo(BoundRefKey boundRefKey, String value) {
        return new BoundDimFilter(boundRefKey.getDimension(), null, value, Boolean.valueOf(false), Boolean.valueOf(false), null, boundRefKey.getExtractionFn(), boundRefKey.getComparator(), null);
    }

    public static BoundDimFilter interval(BoundRefKey boundRefKey, Interval interval) {
        if (!boundRefKey.getComparator().equals(StringComparators.NUMERIC)) {
            throw new ISE("Comparator must be NUMERIC but was[%s]", new Object[]{boundRefKey.getComparator()});
        }
        return new BoundDimFilter(boundRefKey.getDimension(), String.valueOf(interval.getStartMillis()), String.valueOf(interval.getEndMillis()), Boolean.valueOf(false), Boolean.valueOf(true), null, boundRefKey.getExtractionFn(), boundRefKey.getComparator(), null);
    }
}

