/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.logical.LogicalCorrelate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql2rel.RelFieldTrimmer;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.druid.sql.calcite.rule.logical.LogicalUnnest;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DruidRelFieldTrimmer
extends RelFieldTrimmer {
    private final RelBuilder relBuilder;

    public DruidRelFieldTrimmer(@Nullable SqlValidator validator, RelBuilder relBuilder) {
        super(validator, relBuilder);
        this.relBuilder = relBuilder;
    }

    protected RelFieldTrimmer.TrimResult dummyProject(int fieldCount, RelNode input) {
        return this.makeIdentityMapping(input);
    }

    protected RelFieldTrimmer.TrimResult dummyProject(int fieldCount, RelNode input, @Nullable RelNode originalRelNode) {
        if (fieldCount != 0) {
            return super.dummyProject(fieldCount, input, originalRelNode);
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)0);
        if (input.getRowType().getFieldCount() == 0) {
            return this.result(input, mapping);
        }
        this.relBuilder.push(input);
        this.relBuilder.project(Collections.emptyList(), Collections.emptyList());
        RelNode newProject = this.relBuilder.build();
        if (originalRelNode != null) {
            newProject = RelOptUtil.propagateRelHints((RelNode)originalRelNode, (RelNode)newProject);
        }
        return this.result(newProject, mapping);
    }

    private RelFieldTrimmer.TrimResult makeIdentityMapping(RelNode input) {
        Mappings.IdentityMapping mapping = Mappings.createIdentity((int)input.getRowType().getFieldCount());
        return this.result(input, (Mapping)mapping);
    }

    public RelFieldTrimmer.TrimResult trimFields(LogicalCorrelate correlate, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        if (!extraFields.isEmpty()) {
            return this.trimFields((RelNode)correlate, fieldsUsed, extraFields);
        }
        fieldsUsed = fieldsUsed.union(correlate.getRequiredColumns());
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        int changeCount = 0;
        int offset = 0;
        for (RelNode input : correlate.getInputs()) {
            RelDataType inputRowType = input.getRowType();
            int inputFieldCount = inputRowType.getFieldCount();
            ImmutableBitSet currentInputFieldsUsed = fieldsUsed.intersect(ImmutableBitSet.range((int)offset, (int)(offset + inputFieldCount))).shift(-offset);
            RelFieldTrimmer.TrimResult trimResult = this.dispatchTrimFields(input, currentInputFieldsUsed, extraFields);
            newInputs.add((RelNode)trimResult.left);
            if (trimResult.left != input) {
                ++changeCount;
            }
            Mapping inputMapping = (Mapping)trimResult.right;
            inputMappings.add(inputMapping);
            offset += inputFieldCount;
        }
        if (changeCount == 0) {
            return this.result((RelNode)correlate, (Mapping)Mappings.createIdentity((int)correlate.getRowType().getFieldCount()));
        }
        Mapping mapping = this.makeMapping(inputMappings);
        RexBuilder rexBuilder = correlate.getCluster().getRexBuilder();
        LogicalCorrelate newCorrelate = correlate.copy(correlate.getTraitSet(), (RelNode)newInputs.get(0), ((RelNode)newInputs.get(1)).accept((RelShuttle)new RexRewritingRelShuttle(new RexCorrelVariableMapShuttle(correlate.getCorrelationId(), ((RelNode)newInputs.get(0)).getRowType(), mapping, rexBuilder))), correlate.getCorrelationId(), correlate.getRequiredColumns().permute((Mappings.TargetMapping)mapping), correlate.getJoinType());
        return this.result((RelNode)newCorrelate, mapping);
    }

    public RelFieldTrimmer.TrimResult trimFields(LogicalUnnest correlate, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        if (!extraFields.isEmpty()) {
            return this.trimFields((RelNode)correlate, fieldsUsed, extraFields);
        }
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(extraFields);
        correlate.getUnnestExpr().accept((RexVisitor)inputFinder);
        ImmutableBitSet finderFields = inputFinder.build();
        ImmutableBitSet inputFieldsUsed = ImmutableBitSet.builder().addAll(fieldsUsed.clear(correlate.getRowType().getFieldCount() - 1)).addAll(finderFields).build();
        RelNode input = correlate.getInput();
        RelFieldTrimmer.TrimResult trimResult = this.trimChild((RelNode)correlate, input, inputFieldsUsed, extraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input) {
            return this.result((RelNode)correlate, (Mapping)Mappings.createIdentity((int)correlate.getRowType().getFieldCount()));
        }
        Mapping mapping = this.makeMapping((List<Mapping>)ImmutableList.of((Object)inputMapping, (Object)Mappings.createIdentity((int)1)));
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, new RelNode[]{newInput});
        RexNode newUnnestExpr = (RexNode)correlate.getUnnestExpr().accept((RexVisitor)shuttle);
        RexNode newFilterExpr = correlate.getFilter();
        LogicalUnnest newCorrelate = correlate.copy(correlate.getTraitSet(), newInput, newUnnestExpr, newFilterExpr);
        return this.result((RelNode)newCorrelate, mapping);
    }

    private Mapping makeMapping(List<Mapping> inputMappings) {
        int fieldCount = 0;
        int newFieldCount = 0;
        for (Mapping mapping : inputMappings) {
            fieldCount += mapping.getSourceCount();
            newFieldCount += mapping.getTargetCount();
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)newFieldCount);
        int offset = 0;
        int newOffset = 0;
        for (int i = 0; i < inputMappings.size(); ++i) {
            Mapping inputMapping = inputMappings.get(i);
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source + offset, pair.target + newOffset);
            }
            offset += inputMapping.getSourceCount();
            newOffset += inputMapping.getTargetCount();
        }
        return mapping;
    }

    static class RexRewritingRelShuttle
    extends RelHomogeneousShuttle {
        private final RexShuttle rexVisitor;

        RexRewritingRelShuttle(RexShuttle rexVisitor) {
            this.rexVisitor = rexVisitor;
        }

        public RelNode visit(RelNode other) {
            RelNode next = super.visit(other);
            return next.accept(this.rexVisitor);
        }
    }

    static class RexCorrelVariableMapShuttle
    extends RexShuttle {
        private final CorrelationId correlationId;
        private final Mapping mapping;
        private final RelDataType newCorrelRowType;
        private final RexBuilder rexBuilder;

        public RexCorrelVariableMapShuttle(CorrelationId correlationId, RelDataType newCorrelRowType, Mapping mapping, RexBuilder rexBuilder) {
            this.correlationId = correlationId;
            this.newCorrelRowType = newCorrelRowType;
            this.mapping = mapping;
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            if (fieldAccess.getReferenceExpr() instanceof RexCorrelVariable) {
                RexCorrelVariable referenceExpr;
                RexCorrelVariable encounteredCorrelationId = referenceExpr = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                if (encounteredCorrelationId.id.equals((Object)this.correlationId)) {
                    int sourceIndex = fieldAccess.getField().getIndex();
                    return this.rexBuilder.makeFieldAccess(this.map(referenceExpr), this.mapping.getTarget(sourceIndex));
                }
            }
            return super.visitFieldAccess(fieldAccess);
        }

        private RexNode map(RexCorrelVariable referenceExpr) {
            return this.rexBuilder.makeCorrel(this.newCorrelRowType, referenceExpr.id);
        }
    }
}

