/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule.logical;

import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.sql.calcite.rel.logical.DruidJoin;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalConvention;
import org.apache.druid.sql.calcite.rule.DruidJoinRule;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DruidJoinRule
extends ConverterRule {
    public DruidJoinRule(Class<? extends RelNode> clazz, RelTrait in, RelTrait out, String descriptionPrefix) {
        super(ConverterRule.Config.INSTANCE.withConversion(clazz, in, out, descriptionPrefix));
    }

    public @Nullable RelNode convert(RelNode rel) {
        Join join = (Join)rel;
        RelTraitSet newTrait = join.getTraitSet().replace((RelTrait)DruidLogicalConvention.instance());
        DruidJoinRule.ConditionAnalysis analysis = org.apache.druid.sql.calcite.rule.DruidJoinRule.analyzeCondition(join.getCondition(), join.getLeft().getRowType(), join.getCluster().getRexBuilder());
        if (analysis.errorStr != null) {
            throw InvalidSqlInput.exception((String)analysis.errorStr, (Object[])new Object[0]);
        }
        return new DruidJoin(join.getCluster(), newTrait, (List<RelHint>)join.getHints(), DruidJoinRule.convert((RelNode)join.getLeft(), (RelTrait)DruidLogicalConvention.instance()), DruidJoinRule.convert((RelNode)join.getRight(), (RelTrait)DruidLogicalConvention.instance()), analysis.getConditionWithUnsupportedSubConditionsIgnored(join.getCluster().getRexBuilder()), join.getVariablesSet(), join.getJoinType());
    }

    public static boolean isSupportedPredicate(Join join, JoinRelType joinType, RexNode exp) {
        DruidJoinRule.ConditionAnalysis analysis = org.apache.druid.sql.calcite.rule.DruidJoinRule.analyzeCondition(exp, join.getLeft().getRowType(), join.getCluster().getRexBuilder());
        return analysis.errorStr == null;
    }
}

