/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class TerminateInstancesRequestMarshaller
implements Marshaller<Request<TerminateInstancesRequest>, TerminateInstancesRequest> {
    public Request<TerminateInstancesRequest> marshall(TerminateInstancesRequest terminateInstancesRequest) {
        if (terminateInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)terminateInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "TerminateInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList terminateInstancesRequestInstanceIdsList = (SdkInternalList)terminateInstancesRequest.getInstanceIds();
        if (!terminateInstancesRequestInstanceIdsList.isEmpty() || !terminateInstancesRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String terminateInstancesRequestInstanceIdsListValue : terminateInstancesRequestInstanceIdsList) {
                if (terminateInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)terminateInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

