/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.controller;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.msq.dart.worker.DartQueryableSegment;
import org.apache.druid.msq.dart.worker.WorkerId;
import org.apache.druid.msq.exec.SegmentSource;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.input.table.DataServerRequestDescriptor;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.input.table.TableInputSpec;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterUtils;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineLookup;

public class DartTableInputSpecSlicer
implements InputSpecSlicer {
    private static final int UNKNOWN = -1;
    private final Object2IntMap<String> workerIdToNumber;
    private final TimelineServerView serverView;

    DartTableInputSpecSlicer(Object2IntMap<String> workerIdToNumber, TimelineServerView serverView) {
        this.workerIdToNumber = workerIdToNumber;
        this.serverView = serverView;
    }

    public static DartTableInputSpecSlicer createFromWorkerIds(List<String> workerIds, TimelineServerView serverView) {
        Object2IntOpenHashMap reverseWorkers = new Object2IntOpenHashMap();
        reverseWorkers.defaultReturnValue(-1);
        for (int i = 0; i < workerIds.size(); ++i) {
            reverseWorkers.put((Object)WorkerId.fromString(workerIds.get(i)).getHostAndPort(), i);
        }
        return new DartTableInputSpecSlicer((Object2IntMap<String>)reverseWorkers, serverView);
    }

    @Override
    public boolean canSliceDynamic(InputSpec inputSpec) {
        return false;
    }

    @Override
    public List<InputSlice> sliceStatic(InputSpec inputSpec, int maxNumSlices) {
        TableInputSpec tableInputSpec = (TableInputSpec)inputSpec;
        TimelineLookup timeline = this.serverView.getTimeline(new TableDataSource(tableInputSpec.getDataSource())).orElse(null);
        if (timeline == null) {
            return Collections.emptyList();
        }
        Set<DartQueryableSegment> prunedSegments = DartTableInputSpecSlicer.findQueryableDataSegments(tableInputSpec, timeline, serverSelector -> this.findWorkerForServerSelector((ServerSelector)serverSelector, maxNumSlices));
        ArrayList<List<DartQueryableSegment>> assignments = new ArrayList<List<DartQueryableSegment>>(maxNumSlices);
        while (assignments.size() < maxNumSlices) {
            assignments.add(null);
        }
        int nextRoundRobinWorker = 0;
        for (DartQueryableSegment segment : prunedSegments) {
            int worker;
            if (segment.getWorkerNumber() == -1) {
                worker = nextRoundRobinWorker;
                nextRoundRobinWorker = (nextRoundRobinWorker + 1) % maxNumSlices;
            } else {
                worker = segment.getWorkerNumber();
            }
            if (assignments.get(worker) == null) {
                assignments.set(worker, new ArrayList());
            }
            ((List)assignments.get(worker)).add(segment);
        }
        return DartTableInputSpecSlicer.makeSegmentSlices(tableInputSpec.getDataSource(), assignments);
    }

    @Override
    public List<InputSlice> sliceDynamic(InputSpec inputSpec, int maxNumSlices, int maxFilesPerSlice, long maxBytesPerSlice) {
        throw new UnsupportedOperationException();
    }

    int findWorkerForServerSelector(ServerSelector serverSelector, int maxNumSlices) {
        QueryableDruidServer server = serverSelector.pick(null);
        if (server == null) {
            return -1;
        }
        String serverHostAndPort = server.getServer().getHost();
        int workerNumber = this.workerIdToNumber.getInt((Object)serverHostAndPort);
        if (workerNumber != -1 && workerNumber < maxNumSlices) {
            return workerNumber;
        }
        return -1;
    }

    static Set<DartQueryableSegment> findQueryableDataSegments(TableInputSpec tableInputSpec, TimelineLookup<?, ServerSelector> timeline, ToIntFunction<ServerSelector> toWorkersFunction) {
        FluentIterable allSegments = FluentIterable.from((Iterable)JodaUtils.condenseIntervals(tableInputSpec.getIntervals())).transformAndConcat(arg_0 -> timeline.lookup(arg_0)).transformAndConcat(holder -> FluentIterable.from((Iterable)holder.getObject()).filter(chunk -> DartTableInputSpecSlicer.shouldIncludeSegment((ServerSelector)chunk.getObject())).transform(chunk -> {
            ServerSelector serverSelector = (ServerSelector)chunk.getObject();
            DataSegment dataSegment = serverSelector.getSegment();
            int worker = toWorkersFunction.applyAsInt(serverSelector);
            return new DartQueryableSegment(dataSegment, holder.getInterval(), worker);
        }).filter(segment -> !segment.getSegment().isTombstone()));
        return DimFilterUtils.filterShards((DimFilter)tableInputSpec.getFilter(), tableInputSpec.getFilterFields(), (Iterable)allSegments, segment -> segment.getSegment().getShardSpec(), new HashMap());
    }

    static List<InputSlice> makeSegmentSlices(String dataSource, List<List<DartQueryableSegment>> assignments) {
        ArrayList<InputSlice> retVal = new ArrayList<InputSlice>(assignments.size());
        for (List<DartQueryableSegment> assignment : assignments) {
            if (assignment == null || assignment.isEmpty()) {
                retVal.add(NilInputSlice.INSTANCE);
                continue;
            }
            ArrayList<RichSegmentDescriptor> descriptors = new ArrayList<RichSegmentDescriptor>();
            for (DartQueryableSegment segment : assignment) {
                if (!dataSource.equals(segment.getSegment().getDataSource())) {
                    throw new ISE("Expected dataSource[%s] but got[%s]", new Object[]{dataSource, segment.getSegment().getDataSource()});
                }
                descriptors.add(DartTableInputSpecSlicer.toRichSegmentDescriptor(segment));
            }
            retVal.add(new SegmentsInputSlice(dataSource, descriptors, (List<DataServerRequestDescriptor>)ImmutableList.of()));
        }
        return retVal;
    }

    static RichSegmentDescriptor toRichSegmentDescriptor(DartQueryableSegment segment) {
        return new RichSegmentDescriptor(segment.getSegment().getInterval(), segment.getInterval(), segment.getSegment().getVersion(), segment.getSegment().getShardSpec().getPartitionNum());
    }

    static boolean shouldIncludeSegment(ServerSelector serverSelector) {
        if (serverSelector.getSegment().isTombstone()) {
            return false;
        }
        int numRealtimeServers = 0;
        int numOtherServers = 0;
        for (DruidServerMetadata server : serverSelector.getAllServers()) {
            if (SegmentSource.REALTIME.getUsedServerTypes().contains(server.getType())) {
                ++numRealtimeServers;
                continue;
            }
            ++numOtherServers;
        }
        return numOtherServers > 0 || numOtherServers + numRealtimeServers == 0;
    }
}

