/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.exec.DataServerQueryHandlerFactory;
import org.apache.druid.msq.exec.ProcessingBuffers;
import org.apache.druid.msq.exec.WorkerContext;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.exec.WorkerStorageParameters;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.incremental.NoopRowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.loading.DataSegmentPusher;

public class DartFrameContext
implements FrameContext {
    private final StageId stageId;
    private final SegmentWrangler segmentWrangler;
    private final GroupingEngine groupingEngine;
    private final DataSegmentProvider dataSegmentProvider;
    private final WorkerContext workerContext;
    @Nullable
    private final ResourceHolder<ProcessingBuffers> processingBuffers;
    private final WorkerMemoryParameters memoryParameters;
    private final WorkerStorageParameters storageParameters;

    public DartFrameContext(StageId stageId, WorkerContext workerContext, SegmentWrangler segmentWrangler, GroupingEngine groupingEngine, DataSegmentProvider dataSegmentProvider, @Nullable ResourceHolder<ProcessingBuffers> processingBuffers, WorkerMemoryParameters memoryParameters, WorkerStorageParameters storageParameters) {
        this.stageId = stageId;
        this.segmentWrangler = segmentWrangler;
        this.groupingEngine = groupingEngine;
        this.dataSegmentProvider = dataSegmentProvider;
        this.workerContext = workerContext;
        this.processingBuffers = processingBuffers;
        this.memoryParameters = memoryParameters;
        this.storageParameters = storageParameters;
    }

    @Override
    public SegmentWrangler segmentWrangler() {
        return this.segmentWrangler;
    }

    @Override
    public GroupingEngine groupingEngine() {
        return this.groupingEngine;
    }

    @Override
    public RowIngestionMeters rowIngestionMeters() {
        return new NoopRowIngestionMeters();
    }

    @Override
    public DataSegmentProvider dataSegmentProvider() {
        return this.dataSegmentProvider;
    }

    @Override
    public File tempDir() {
        return new File(this.workerContext.tempDir(), this.stageId.toString());
    }

    @Override
    public ObjectMapper jsonMapper() {
        return this.workerContext.jsonMapper();
    }

    @Override
    public IndexIO indexIO() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File persistDir() {
        return new File(this.tempDir(), "persist");
    }

    @Override
    public DataSegmentPusher segmentPusher() {
        throw DruidException.defensive((String)"Ingestion not implemented", (Object[])new Object[0]);
    }

    @Override
    public IndexMergerV9 indexMerger() {
        throw DruidException.defensive((String)"Ingestion not implemented", (Object[])new Object[0]);
    }

    @Override
    public ProcessingBuffers processingBuffers() {
        if (this.processingBuffers != null) {
            return (ProcessingBuffers)this.processingBuffers.get();
        }
        throw new ISE("No processing buffers", new Object[0]);
    }

    @Override
    public WorkerMemoryParameters memoryParameters() {
        return this.memoryParameters;
    }

    @Override
    public WorkerStorageParameters storageParameters() {
        return this.storageParameters;
    }

    @Override
    public DataServerQueryHandlerFactory dataServerQueryHandlerFactory() {
        return null;
    }

    @Override
    public void close() {
        if (this.processingBuffers != null) {
            this.processingBuffers.close();
        }
    }
}

