/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.dart.worker;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.messages.server.Outbox;
import org.apache.druid.msq.dart.Dart;
import org.apache.druid.msq.dart.controller.messages.ControllerMessage;
import org.apache.druid.msq.dart.worker.DartWorkerClientImpl;
import org.apache.druid.msq.dart.worker.DartWorkerContext;
import org.apache.druid.msq.dart.worker.DartWorkerFactory;
import org.apache.druid.msq.exec.MemoryIntrospector;
import org.apache.druid.msq.exec.ProcessingBuffersProvider;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.exec.WorkerImpl;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.groupby.GroupingEngine;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.server.DruidNode;

public class DartWorkerFactoryImpl
implements DartWorkerFactory {
    private final DruidNode selfNode;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final Injector injector;
    private final ServiceClientFactory serviceClientFactory;
    private final DruidProcessingConfig processingConfig;
    private final SegmentWrangler segmentWrangler;
    private final GroupingEngine groupingEngine;
    private final DataSegmentProvider dataSegmentProvider;
    private final MemoryIntrospector memoryIntrospector;
    private final ProcessingBuffersProvider processingBuffersProvider;
    private final Outbox<ControllerMessage> outbox;

    @Inject
    public DartWorkerFactoryImpl(@Self DruidNode selfNode, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, Injector injector, @EscalatedGlobal ServiceClientFactory serviceClientFactory, DruidProcessingConfig processingConfig, SegmentWrangler segmentWrangler, GroupingEngine groupingEngine, @Dart DataSegmentProvider dataSegmentProvider, MemoryIntrospector memoryIntrospector, @Dart ProcessingBuffersProvider processingBuffersProvider, Outbox<ControllerMessage> outbox) {
        this.selfNode = selfNode;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.injector = injector;
        this.serviceClientFactory = serviceClientFactory;
        this.processingConfig = processingConfig;
        this.segmentWrangler = segmentWrangler;
        this.groupingEngine = groupingEngine;
        this.dataSegmentProvider = dataSegmentProvider;
        this.memoryIntrospector = memoryIntrospector;
        this.processingBuffersProvider = processingBuffersProvider;
        this.outbox = outbox;
    }

    @Override
    public Worker build(String queryId, String controllerHost, File tempDir, QueryContext queryContext) {
        DartWorkerContext workerContext = new DartWorkerContext(queryId, controllerHost, this.selfNode, this.jsonMapper, this.injector, new DartWorkerClientImpl(queryId, this.serviceClientFactory, this.smileMapper, null), this.processingConfig, this.segmentWrangler, this.groupingEngine, this.dataSegmentProvider, this.memoryIntrospector, this.processingBuffersProvider, this.outbox, tempDir, queryContext);
        return new WorkerImpl(null, workerContext);
    }
}

