/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutors;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.exec.DataServerQueryHandler;
import org.apache.druid.msq.input.table.DataServerRequestDescriptor;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.rpc.ServiceClientFactory;

public class DataServerQueryHandlerFactory
implements Closeable {
    private static final Logger log = new Logger(DataServerQueryHandlerFactory.class);
    private static final int DEFAULT_THREAD_COUNT = 4;
    private final CoordinatorClient coordinatorClient;
    private final ServiceClientFactory serviceClientFactory;
    private final ObjectMapper objectMapper;
    private final QueryToolChestWarehouse warehouse;
    private final ScheduledExecutorService queryCancellationExecutor;

    public DataServerQueryHandlerFactory(CoordinatorClient coordinatorClient, ServiceClientFactory serviceClientFactory, ObjectMapper objectMapper, QueryToolChestWarehouse warehouse) {
        this.coordinatorClient = coordinatorClient;
        this.serviceClientFactory = serviceClientFactory;
        this.objectMapper = objectMapper;
        this.warehouse = warehouse;
        this.queryCancellationExecutor = ScheduledExecutors.fixed((int)4, (String)"query-cancellation-executor");
    }

    public DataServerQueryHandler createDataServerQueryHandler(String dataSource, ChannelCounters channelCounters, DataServerRequestDescriptor dataServerRequestDescriptor) {
        return new DataServerQueryHandler(dataSource, channelCounters, this.serviceClientFactory, this.coordinatorClient, this.objectMapper, this.warehouse, this.queryCancellationExecutor, dataServerRequestDescriptor);
    }

    @Override
    public void close() {
        log.info("Waiting for any data server queries to be canceled.", new Object[0]);
        this.queryCancellationExecutor.shutdown();
        try {
            if (!this.queryCancellationExecutor.awaitTermination(1L, TimeUnit.MINUTES)) {
                log.error("Unable to cancel all ongoing queries.", new Object[0]);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RE((Throwable)e);
        }
    }
}

