/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.msq.rpc.BaseWorkerClientImpl;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.SpecificTaskRetryPolicy;
import org.apache.druid.rpc.indexing.SpecificTaskServiceLocator;
import org.apache.druid.utils.CloseableUtils;

public class IndexerWorkerClient
extends BaseWorkerClientImpl {
    private final ServiceClientFactory clientFactory;
    private final OverlordClient overlordClient;
    @GuardedBy(value="clientMap")
    private final Map<String, Pair<ServiceClient, Closeable>> clientMap = new HashMap<String, Pair<ServiceClient, Closeable>>();

    public IndexerWorkerClient(ServiceClientFactory clientFactory, OverlordClient overlordClient, ObjectMapper jsonMapper) {
        super(jsonMapper, "application/json");
        this.clientFactory = clientFactory;
        this.overlordClient = overlordClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<String, Pair<ServiceClient, Closeable>> map = this.clientMap;
        synchronized (map) {
            try {
                List closeables = this.clientMap.values().stream().map(pair -> (Closeable)pair.rhs).collect(Collectors.toList());
                CloseableUtils.closeAll(closeables);
            }
            finally {
                this.clientMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServiceClient getClient(String workerId) {
        Map<String, Pair<ServiceClient, Closeable>> map = this.clientMap;
        synchronized (map) {
            return (ServiceClient)this.clientMap.computeIfAbsent((String)workerId, (Function<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getClient$1(java.lang.String java.lang.String ), (Ljava/lang/String;)Lorg/apache/druid/java/util/common/Pair;)((IndexerWorkerClient)this, (String)workerId)).lhs;
        }
    }

    private /* synthetic */ Pair lambda$getClient$1(String workerId, String id) {
        SpecificTaskServiceLocator locator = new SpecificTaskServiceLocator(id, this.overlordClient);
        ServiceClient client = this.clientFactory.makeClient(id, (ServiceLocator)locator, (ServiceRetryPolicy)new SpecificTaskRetryPolicy(workerId, (ServiceRetryPolicy)StandardRetryPolicy.unlimitedWithoutRetryLogging()));
        return Pair.of((Object)client, (Object)locator);
    }
}

