/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.DurationGranularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.msq.indexing.error.BaseMSQFault;
import org.joda.time.Interval;
import org.joda.time.Period;

@JsonTypeName(value="InsertCannotAllocateSegment")
public class InsertCannotAllocateSegmentFault
extends BaseMSQFault {
    static final String CODE = "InsertCannotAllocateSegment";
    private final String dataSource;
    private final Interval interval;
    @Nullable
    private final Interval allocatedInterval;

    @JsonCreator
    public InsertCannotAllocateSegmentFault(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @Nullable @JsonProperty(value="allocatedInterval") Interval allocatedInterval) {
        super(CODE, InsertCannotAllocateSegmentFault.getErrorMessage(dataSource, interval, allocatedInterval));
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.allocatedInterval = allocatedInterval;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Nullable
    @JsonProperty
    public Interval getAllocatedInterval() {
        return this.allocatedInterval;
    }

    private static String getErrorMessage(String dataSource, Interval interval, @Nullable Interval allocatedInterval) {
        String errorMessage = allocatedInterval == null ? StringUtils.format((String)"Cannot allocate segment for dataSource [%s], interval [%s]. This can happen if the prior ingestion uses non-extendable shard specs or if the partitioned by granularity is different from the granularity of the pre-existing segments. Check the granularities of the pre-existing segments or re-run the ingestion with REPLACE to overwrite over the existing data", (Object[])new Object[]{dataSource, interval}) : StringUtils.format((String)"Requested segment for dataSource [%s], interval [%s], but got [%s] interval instead. This happens when an overlapping segment is already present with a coarser granularity for the requested interval. Either set the partition granularity for the INSERT to [%s] to append to existing data or use REPLACE to overwrite over the pre-existing segment", (Object[])new Object[]{dataSource, interval, allocatedInterval, InsertCannotAllocateSegmentFault.convertIntervalToGranularityString(allocatedInterval)});
        return errorMessage;
    }

    private static String convertIntervalToGranularityString(Interval interval) {
        try {
            return GranularityType.fromPeriod((Period)interval.toPeriod()).name();
        }
        catch (Exception e) {
            return new DurationGranularity(interval.toDurationMillis(), null).toString();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertCannotAllocateSegmentFault that = (InsertCannotAllocateSegmentFault)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.interval, that.interval) && Objects.equals(this.allocatedInterval, that.allocatedInterval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataSource, this.interval, this.allocatedInterval);
    }
}

