/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;

public class MapInputSpecSlicer
implements InputSpecSlicer {
    private final Map<Class<? extends InputSpec>, InputSpecSlicer> splitterMap;

    public MapInputSpecSlicer(Map<Class<? extends InputSpec>, InputSpecSlicer> splitterMap) {
        this.splitterMap = ImmutableMap.copyOf(splitterMap);
    }

    @Override
    public boolean canSliceDynamic(InputSpec inputSpec) {
        return this.getSlicer(inputSpec.getClass()).canSliceDynamic(inputSpec);
    }

    @Override
    public List<InputSlice> sliceStatic(InputSpec inputSpec, int maxNumSlices) {
        return this.getSlicer(inputSpec.getClass()).sliceStatic(inputSpec, maxNumSlices);
    }

    @Override
    public List<InputSlice> sliceDynamic(InputSpec inputSpec, int maxNumSlices, int maxFilesPerSlice, long maxBytesPerSlice) {
        return this.getSlicer(inputSpec.getClass()).sliceDynamic(inputSpec, maxNumSlices, maxFilesPerSlice, maxBytesPerSlice);
    }

    private InputSpecSlicer getSlicer(Class<? extends InputSpec> clazz) {
        InputSpecSlicer slicer = this.splitterMap.get(clazz);
        if (slicer == null) {
            throw new ISE("Cannot handle inputSpec of class [%s]", new Object[]{clazz.getName()});
        }
        return slicer;
    }
}

