/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.external;

import com.google.common.collect.Iterators;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.InputStats;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.counters.WarningCounters;
import org.apache.druid.msq.indexing.CountableInputSourceReader;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.NilInputSource;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.input.external.ExternalInputSlice;
import org.apache.druid.msq.input.external.ExternalSegment;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.util.DimensionSchemaUtils;
import org.apache.druid.segment.CompleteSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.incremental.SimpleRowIngestionMeters;
import org.apache.druid.timeline.SegmentId;

public class ExternalInputSliceReader
implements InputSliceReader {
    public static final String SEGMENT_ID = "__external";
    private final File temporaryDirectory;

    public ExternalInputSliceReader(File temporaryDirectory) {
        this.temporaryDirectory = temporaryDirectory;
    }

    @Override
    public int numReadableInputs(InputSlice slice) {
        ExternalInputSlice externalInputSlice = (ExternalInputSlice)slice;
        return externalInputSlice.getInputSources().size();
    }

    @Override
    public ReadableInputs attach(int inputNumber, InputSlice slice, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        ExternalInputSlice externalInputSlice = (ExternalInputSlice)slice;
        return ReadableInputs.segments(() -> Iterators.transform(ExternalInputSliceReader.inputSourceSegmentIterator(externalInputSlice.getInputSources(), externalInputSlice.getInputFormat(), externalInputSlice.getSignature(), new File(this.temporaryDirectory, String.valueOf(inputNumber)), counters.channel(CounterNames.inputChannel(inputNumber)).setTotalFiles(slice.fileCount()), counters.warnings(), warningPublisher), ReadableInput::segment));
    }

    private static Iterator<SegmentWithDescriptor> inputSourceSegmentIterator(List<InputSource> inputSources, InputFormat inputFormat, RowSignature signature, File temporaryDirectory, ChannelCounters channelCounters, WarningCounters warningCounters, Consumer<Throwable> warningPublisher) {
        InputRowSchema schema = new InputRowSchema(new TimestampSpec("__time", "auto", DateTimes.utc((long)0L)), new DimensionsSpec(signature.getColumnNames().stream().map(column -> DimensionSchemaUtils.createDimensionSchemaForExtern(column, signature.getColumnType(column).orElse(null))).collect(Collectors.toList())), ColumnsFilter.all());
        try {
            FileUtils.mkdirp((File)temporaryDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Iterators.transform(inputSources.iterator(), inputSource -> {
            boolean incrementCounters = ExternalInputSliceReader.isFileBasedInputSource(inputSource);
            SimpleRowIngestionMeters inputStats = new SimpleRowIngestionMeters();
            InputSourceReader reader = incrementCounters ? new CountableInputSourceReader(inputSource.reader(schema, inputFormat, temporaryDirectory), channelCounters) : inputSource.reader(schema, inputFormat, temporaryDirectory);
            SegmentId segmentId = SegmentId.dummy((String)SEGMENT_ID);
            ExternalSegment segment = new ExternalSegment((InputSource)inputSource, reader, (InputStats)inputStats, warningCounters, warningPublisher, channelCounters, signature);
            return new SegmentWithDescriptor(() -> ExternalInputSliceReader.lambda$inputSourceSegmentIterator$2((Segment)segment), new RichSegmentDescriptor(segmentId.toDescriptor(), null));
        });
    }

    public static boolean isFileBasedInputSource(InputSource inputSource) {
        return !(inputSource instanceof NilInputSource) && !(inputSource instanceof InlineInputSource);
    }

    private static /* synthetic */ ResourceHolder lambda$inputSourceSegmentIterator$2(Segment segment) {
        return ResourceHolder.fromCloseable((Closeable)new CompleteSegment(null, segment));
    }
}

