/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.kernel.GlobalSortShuffleSpec;
import org.apache.druid.msq.kernel.ShuffleKind;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollector;

public class GlobalSortTargetSizeShuffleSpec
implements GlobalSortShuffleSpec {
    public static final String TYPE = "targetSize";
    private final ClusterBy clusterBy;
    private final long targetSize;
    private final boolean aggregate;

    @JsonCreator
    public GlobalSortTargetSizeShuffleSpec(@JsonProperty(value="clusterBy") ClusterBy clusterBy, @JsonProperty(value="targetSize") long targetSize, @JsonProperty(value="aggregate") boolean aggregate) {
        this.clusterBy = (ClusterBy)Preconditions.checkNotNull((Object)clusterBy, (Object)"clusterBy");
        this.targetSize = targetSize;
        this.aggregate = aggregate;
        if (!clusterBy.sortable()) {
            throw new IAE("ClusterBy key must be sortable", new Object[0]);
        }
    }

    @Override
    public ShuffleKind kind() {
        return ShuffleKind.GLOBAL_SORT;
    }

    @Override
    @JsonProperty(value="aggregate")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean doesAggregate() {
        return this.aggregate;
    }

    @Override
    public boolean mustGatherResultKeyStatistics() {
        return true;
    }

    @Override
    public int partitionCount() {
        throw new ISE("Number of partitions not known for [%s].", new Object[]{this.kind()});
    }

    @Override
    public Either<Long, ClusterByPartitions> generatePartitionsForGlobalSort(@Nullable ClusterByStatisticsCollector collector, int maxNumPartitions) {
        long expectedPartitions = collector.estimatedTotalWeight() / this.targetSize;
        if (expectedPartitions > (long)maxNumPartitions) {
            return Either.error((Object)expectedPartitions);
        }
        collector.logSketches();
        ClusterByPartitions generatedPartitions = collector.generatePartitionsWithTargetWeight(this.targetSize);
        if (generatedPartitions.size() <= maxNumPartitions) {
            return Either.value((Object)generatedPartitions);
        }
        return Either.error((Object)generatedPartitions.size());
    }

    @Override
    @JsonProperty
    public ClusterBy clusterBy() {
        return this.clusterBy;
    }

    @JsonProperty
    long targetSize() {
        return this.targetSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSortTargetSizeShuffleSpec that = (GlobalSortTargetSizeShuffleSpec)o;
        return this.targetSize == that.targetSize && this.aggregate == that.aggregate && Objects.equals(this.clusterBy, that.clusterBy);
    }

    public int hashCode() {
        return Objects.hash(this.clusterBy, this.targetSize, this.aggregate);
    }

    public String toString() {
        return "TargetSizeShuffleSpec{clusterBy=" + String.valueOf(this.clusterBy) + ", targetSize=" + this.targetSize + ", aggregate=" + this.aggregate + "}";
    }
}

