/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.key.KeyOrder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.DataSourcePlan;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.QueryKitSpec;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.ShuffleSpecFactories;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.msq.querykit.common.OffsetLimitFrameProcessorFactory;
import org.apache.druid.msq.querykit.groupby.GroupByPostShuffleFrameProcessorFactory;
import org.apache.druid.msq.querykit.groupby.GroupByPreShuffleFrameProcessorFactory;
import org.apache.druid.query.DimensionComparisonUtils;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.having.AlwaysHavingSpec;
import org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class GroupByQueryKit
implements QueryKit<GroupByQuery> {
    private final ObjectMapper jsonMapper;

    public GroupByQueryKit(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public QueryDefinition makeQueryDefinition(QueryKitSpec queryKitSpec, GroupByQuery originalQuery, ShuffleSpecFactory resultShuffleSpecFactory, int minStageNumber) {
        boolean partitionBoost;
        ShuffleSpecFactory shuffleSpecFactoryPostAggregation;
        ShuffleSpecFactory shuffleSpecFactoryPreAggregation;
        DefaultLimitSpec limitSpec;
        boolean doLimitOrOffset;
        GroupByQueryKit.validateQuery(originalQuery);
        QueryDefinitionBuilder queryDefBuilder = QueryDefinition.builder(queryKitSpec.getQueryId());
        DataSourcePlan dataSourcePlan = DataSourcePlan.forDataSource(queryKitSpec, originalQuery.context(), originalQuery.getDataSource(), originalQuery.getQuerySegmentSpec(), originalQuery.getFilter(), null, minStageNumber, false);
        dataSourcePlan.getSubQueryDefBuilder().ifPresent(queryDefBuilder::addAll);
        GroupByQuery queryToRun = (GroupByQuery)originalQuery.withDataSource(dataSourcePlan.getNewDataSource());
        int firstStageNumber = Math.max(minStageNumber, queryDefBuilder.getNextStageNumber());
        Granularity segmentGranularity = QueryKitUtils.getSegmentGranularityFromContext(this.jsonMapper, queryToRun.getContext());
        RowSignature intermediateSignature = GroupByQueryKit.computeIntermediateSignature(queryToRun);
        ClusterBy resultClusterByWithoutGranularity = GroupByQueryKit.computeClusterByForResults(queryToRun);
        ClusterBy resultClusterByWithoutPartitionBoost = QueryKitUtils.clusterByWithSegmentGranularity(resultClusterByWithoutGranularity, segmentGranularity);
        ClusterBy intermediateClusterBy = GroupByQueryKit.computeIntermediateClusterBy(queryToRun);
        boolean doOrderBy = !resultClusterByWithoutPartitionBoost.equals((Object)intermediateClusterBy);
        boolean bl = doLimitOrOffset = queryToRun.getLimitSpec() instanceof DefaultLimitSpec && (((DefaultLimitSpec)queryToRun.getLimitSpec()).isLimited() || ((DefaultLimitSpec)queryToRun.getLimitSpec()).isOffset());
        long postAggregationLimitHint = doLimitOrOffset ? ((limitSpec = (DefaultLimitSpec)queryToRun.getLimitSpec()).isLimited() ? (long)(limitSpec.getOffset() + limitSpec.getLimit()) : -1L) : -1L;
        if (intermediateClusterBy.isEmpty() && resultClusterByWithoutPartitionBoost.isEmpty()) {
            shuffleSpecFactoryPreAggregation = ShuffleSpecFactories.singlePartition();
            shuffleSpecFactoryPostAggregation = ShuffleSpecFactories.singlePartitionWithLimit(postAggregationLimitHint);
            partitionBoost = false;
        } else if (doOrderBy) {
            shuffleSpecFactoryPreAggregation = intermediateClusterBy.isEmpty() ? ShuffleSpecFactories.singlePartition() : ShuffleSpecFactories.globalSortWithMaxPartitionCount(queryKitSpec.getNumPartitionsForShuffle());
            shuffleSpecFactoryPostAggregation = doLimitOrOffset ? ShuffleSpecFactories.singlePartitionWithLimit(postAggregationLimitHint) : resultShuffleSpecFactory;
            partitionBoost = true;
        } else {
            shuffleSpecFactoryPreAggregation = doLimitOrOffset || intermediateClusterBy.isEmpty() ? ShuffleSpecFactories.singlePartition() : resultShuffleSpecFactory;
            shuffleSpecFactoryPostAggregation = null;
            partitionBoost = false;
        }
        queryDefBuilder.add(StageDefinition.builder(firstStageNumber).inputs(dataSourcePlan.getInputSpecs()).broadcastInputs(dataSourcePlan.getBroadcastInputs()).signature(intermediateSignature).shuffleSpec(shuffleSpecFactoryPreAggregation.build(intermediateClusterBy, true)).maxWorkerCount(dataSourcePlan.getMaxWorkerCount(queryKitSpec)).processorFactory(new GroupByPreShuffleFrameProcessorFactory(queryToRun)));
        ClusterBy resultClusterBy = GroupByQueryKit.computeResultClusterBy(queryToRun, segmentGranularity, partitionBoost);
        RowSignature resultSignature = GroupByQueryKit.computeResultSignature(queryToRun, segmentGranularity, resultClusterBy, partitionBoost);
        queryDefBuilder.add(StageDefinition.builder(firstStageNumber + 1).inputs(new StageInputSpec(firstStageNumber)).signature(resultSignature).maxWorkerCount(queryKitSpec.getMaxNonLeafWorkerCount()).shuffleSpec(shuffleSpecFactoryPostAggregation != null ? shuffleSpecFactoryPostAggregation.build(resultClusterBy, false) : null).processorFactory(new GroupByPostShuffleFrameProcessorFactory(queryToRun)));
        if (doLimitOrOffset) {
            ShuffleSpec finalShuffleSpec = resultShuffleSpecFactory.build(resultClusterBy, false);
            DefaultLimitSpec limitSpec2 = (DefaultLimitSpec)queryToRun.getLimitSpec();
            queryDefBuilder.add(StageDefinition.builder(firstStageNumber + 2).inputs(new StageInputSpec(firstStageNumber + 1)).signature(resultSignature).maxWorkerCount(1).shuffleSpec(finalShuffleSpec).processorFactory(new OffsetLimitFrameProcessorFactory(limitSpec2.getOffset(), limitSpec2.isLimited() ? Long.valueOf(limitSpec2.getLimit()) : null)));
        }
        return queryDefBuilder.build();
    }

    private static RowSignature computeIntermediateSignature(GroupByQuery query) {
        RowSignature postAggregationSignature = query.getResultRowSignature(RowSignature.Finalization.NO);
        RowSignature.Builder builder = RowSignature.builder();
        for (int i = 0; i < query.getResultRowSizeWithoutPostAggregators(); ++i) {
            builder.add(postAggregationSignature.getColumnName(i), (ColumnType)postAggregationSignature.getColumnType(i).orElse(null));
        }
        return builder.build();
    }

    private static RowSignature computeResultSignature(GroupByQuery query) {
        RowSignature.Finalization finalization = GroupByQueryKit.isFinalize(query) ? RowSignature.Finalization.YES : RowSignature.Finalization.NO;
        return query.getResultRowSignature(finalization);
    }

    private static ClusterBy computeResultClusterBy(GroupByQuery query, Granularity segmentGranularity, boolean partitionBoost) {
        ClusterBy resultClusterByWithoutGranularity = GroupByQueryKit.computeClusterByForResults(query);
        ClusterBy resultClusterByWithoutPartitionBoost = QueryKitUtils.clusterByWithSegmentGranularity(resultClusterByWithoutGranularity, segmentGranularity);
        if (!partitionBoost) {
            return resultClusterByWithoutPartitionBoost;
        }
        ArrayList<KeyColumn> resultClusterByWithPartitionBoostColumns = new ArrayList<KeyColumn>(resultClusterByWithoutPartitionBoost.getColumns());
        resultClusterByWithPartitionBoostColumns.add(new KeyColumn("__boost", KeyOrder.ASCENDING));
        return new ClusterBy(resultClusterByWithPartitionBoostColumns, resultClusterByWithoutPartitionBoost.getBucketByCount());
    }

    private static RowSignature computeResultSignature(GroupByQuery query, Granularity segmentGranularity, ClusterBy resultClusterBy, boolean partitionBoost) {
        RowSignature resultSignatureWithoutPartitionBoost = QueryKitUtils.signatureWithSegmentGranularity(GroupByQueryKit.computeResultSignature(query), segmentGranularity);
        if (!partitionBoost) {
            return QueryKitUtils.sortableSignature(resultSignatureWithoutPartitionBoost, resultClusterBy.getColumns());
        }
        RowSignature resultSignatureWithPartitionBoost = RowSignature.builder().addAll(resultSignatureWithoutPartitionBoost).add("__boost", ColumnType.LONG).build();
        return QueryKitUtils.sortableSignature(resultSignatureWithPartitionBoost, resultClusterBy.getColumns());
    }

    static boolean isFinalize(GroupByQuery query) {
        return query.context().isFinalize(true);
    }

    static ClusterBy computeIntermediateClusterBy(GroupByQuery query) {
        ArrayList<KeyColumn> columns = new ArrayList<KeyColumn>();
        for (DimensionSpec dimension : query.getDimensions()) {
            columns.add(new KeyColumn(dimension.getOutputName(), KeyOrder.ASCENDING));
        }
        return new ClusterBy(columns, 0);
    }

    static ClusterBy computeClusterByForResults(GroupByQuery query) {
        DefaultLimitSpec defaultLimitSpec;
        if (query.getLimitSpec() instanceof DefaultLimitSpec && !(defaultLimitSpec = (DefaultLimitSpec)query.getLimitSpec()).getColumns().isEmpty()) {
            ArrayList<KeyColumn> clusterByColumns = new ArrayList<KeyColumn>();
            for (OrderByColumnSpec orderBy : defaultLimitSpec.getColumns()) {
                clusterByColumns.add(new KeyColumn(orderBy.getDimension(), orderBy.getDirection() == OrderByColumnSpec.Direction.DESCENDING ? KeyOrder.DESCENDING : KeyOrder.ASCENDING));
            }
            return new ClusterBy(clusterByColumns, 0);
        }
        return GroupByQueryKit.computeIntermediateClusterBy(query);
    }

    private static void validateQuery(GroupByQuery query) {
        Preconditions.checkState((!query.getContextSortByDimsFirst() ? 1 : 0) != 0, (Object)"Must not sort by dims first");
        Preconditions.checkState((query.getSubtotalsSpec() == null ? 1 : 0) != 0, (Object)"Must not have 'subtotalsSpec'");
        Preconditions.checkState((query.getHavingSpec() == null || query.getHavingSpec() instanceof DimFilterHavingSpec || query.getHavingSpec() instanceof AlwaysHavingSpec ? 1 : 0) != 0, (Object)"Must use 'filter' or 'always' havingSpec");
        Preconditions.checkState((boolean)query.getGranularity().equals(Granularities.ALL), (Object)"Must have granularity 'all'");
        Preconditions.checkState((query.getLimitSpec() instanceof NoopLimitSpec || query.getLimitSpec() instanceof DefaultLimitSpec ? 1 : 0) != 0, (Object)"Must have noop or default limitSpec");
        RowSignature resultSignature = GroupByQueryKit.computeResultSignature(query);
        QueryKitUtils.verifyRowSignature(resultSignature);
        if (query.getLimitSpec() instanceof DefaultLimitSpec) {
            DefaultLimitSpec defaultLimitSpec = (DefaultLimitSpec)query.getLimitSpec();
            for (OrderByColumnSpec column : defaultLimitSpec.getColumns()) {
                Optional type = resultSignature.getColumnType(column.getDimension());
                if (type.isPresent() && DimensionComparisonUtils.isNaturalComparator((ValueType)((ValueType)((ColumnType)type.get()).getType()), (StringComparator)column.getDimensionComparator())) continue;
                throw new ISE("Must use natural comparator for column [%s] of type [%s]", new Object[]{column.getDimension(), type.orElse(null)});
            }
        }
    }
}

