/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.scan;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.util.SettableLongVirtualColumn;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.InvalidFieldException;
import org.apache.druid.frame.write.InvalidNullByteException;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.Unit;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.DataServerQueryHandler;
import org.apache.druid.msq.exec.DataServerQueryResult;
import org.apache.druid.msq.input.ParseExceptionUtils;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.external.ExternalSegment;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.querykit.BaseLeafFrameProcessor;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.scan.ExternalColumnSelectorFactory;
import org.apache.druid.msq.querykit.scan.ScanQueryKit;
import org.apache.druid.query.Druids;
import org.apache.druid.query.IterableRowsCursorHelper;
import org.apache.druid.query.Order;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.scan.ScanQueryEngine;
import org.apache.druid.query.scan.ScanResultValue;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.CompleteSegment;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.SimpleSettableOffset;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;

public class ScanQueryFrameProcessor
extends BaseLeafFrameProcessor {
    private static final Logger log = new Logger(ScanQueryFrameProcessor.class);
    private final ScanQuery query;
    private final AtomicLong runningCountForLimit;
    private final ObjectMapper jsonMapper;
    private final SettableLongVirtualColumn partitionBoostVirtualColumn;
    private final VirtualColumns frameWriterVirtualColumns;
    private final Closer closer = Closer.create();
    private Cursor cursor;
    private Closeable cursorCloser;
    private Segment segment;
    private final SimpleSettableOffset cursorOffset = new SimpleAscendingOffset(Integer.MAX_VALUE);
    private FrameWriter frameWriter;
    private long currentAllocatorCapacity;
    private SegmentsInputSlice handedOffSegments = null;

    public ScanQueryFrameProcessor(ScanQuery query, @Nullable AtomicLong runningCountForLimit, ObjectMapper jsonMapper, ReadableInput baseInput, Function<SegmentReference, SegmentReference> segmentMapFn, ResourceHolder<WritableFrameChannel> outputChannelHolder, ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder) {
        super(baseInput, segmentMapFn, outputChannelHolder, frameWriterFactoryHolder);
        this.query = query;
        this.runningCountForLimit = runningCountForLimit;
        this.jsonMapper = jsonMapper;
        this.partitionBoostVirtualColumn = new SettableLongVirtualColumn("__boost");
        ArrayList<Object> frameWriterVirtualColumns = new ArrayList<Object>();
        frameWriterVirtualColumns.add(this.partitionBoostVirtualColumn);
        VirtualColumn segmentGranularityVirtualColumn = QueryKitUtils.makeSegmentGranularityVirtualColumn(jsonMapper, query.context());
        if (segmentGranularityVirtualColumn != null) {
            frameWriterVirtualColumns.add(segmentGranularityVirtualColumn);
        }
        this.frameWriterVirtualColumns = VirtualColumns.create(frameWriterVirtualColumns);
    }

    @Override
    public ReturnOrAwait<Object> runIncrementally(IntSet readableInputs) throws IOException {
        if (this.runningCountForLimit != null && this.runningCountForLimit.get() > this.query.getScanRowsOffset() + this.query.getScanRowsLimit()) {
            return ReturnOrAwait.returnObject((Object)Unit.instance());
        }
        return super.runIncrementally(readableInputs);
    }

    @Override
    public void cleanup() throws IOException {
        this.closer.register(this.cursorCloser);
        this.closer.register((Closeable)this.frameWriter);
        this.closer.register(() -> super.cleanup());
        this.closer.close();
    }

    public static Sequence<Object[]> mappingFunction(Sequence<ScanResultValue> inputSequence) {
        return inputSequence.flatMap(resultRow -> {
            List events = (List)resultRow.getEvents();
            return Sequences.simple((Iterable)events);
        }).map(List::toArray);
    }

    private static ScanQuery prepareScanQueryForDataServer(@NotNull ScanQuery scanQuery) {
        if (Order.NONE.equals((Object)scanQuery.getTimeOrder()) && !scanQuery.getOrderBys().isEmpty()) {
            return Druids.ScanQueryBuilder.copy((ScanQuery)scanQuery).orderBy((List)ImmutableList.of()).limit(0L).build();
        }
        return scanQuery;
    }

    @Override
    protected ReturnOrAwait<SegmentsInputSlice> runWithDataServerQuery(DataServerQueryHandler dataServerQueryHandler) throws IOException {
        if (this.cursor == null) {
            ScanQuery preparedQuery = ScanQueryFrameProcessor.prepareScanQueryForDataServer(this.query);
            DataServerQueryResult dataServerQueryResult = dataServerQueryHandler.fetchRowsFromDataServer(preparedQuery, ScanQueryFrameProcessor::mappingFunction, this.closer);
            this.handedOffSegments = dataServerQueryResult.getHandedOffSegments();
            if (!this.handedOffSegments.getDescriptors().isEmpty()) {
                log.info("Query to dataserver for segments found [%d] handed off segments", new Object[]{this.handedOffSegments.getDescriptors().size()});
            }
            RowSignature rowSignature = ScanQueryKit.getAndValidateSignature(preparedQuery, this.jsonMapper);
            List cursors = dataServerQueryResult.getResultsYielders().stream().map(yielder -> {
                Pair cursorFromIterable = IterableRowsCursorHelper.getCursorFromYielder((Yielder)yielder, (RowSignature)rowSignature);
                this.closer.register((Closeable)cursorFromIterable.rhs);
                return (Cursor)cursorFromIterable.lhs;
            }).collect(Collectors.toList());
            Yielder cursorYielder = Yielders.each((Sequence)Sequences.simple(cursors));
            if (cursorYielder.isDone()) {
                cursorYielder.close();
                return ReturnOrAwait.returnObject((Object)this.handedOffSegments);
            }
            long rowsFlushed = this.setNextCursor((Cursor)cursorYielder.get(), null, null);
            this.closer.register((Closeable)cursorYielder);
            if (rowsFlushed > 0L) {
                return ReturnOrAwait.runAgain();
            }
        }
        this.populateFrameWriterAndFlushIfNeededWithExceptionHandling();
        if (this.cursor.isDone()) {
            this.flushFrameWriter();
        }
        if (this.cursor.isDone() && (this.frameWriter == null || this.frameWriter.getNumRows() == 0)) {
            return ReturnOrAwait.returnObject((Object)this.handedOffSegments);
        }
        return ReturnOrAwait.runAgain();
    }

    @Override
    protected ReturnOrAwait<Unit> runWithSegment(SegmentWithDescriptor segment) throws IOException {
        if (this.cursor == null) {
            Cursor nextCursor;
            ResourceHolder segmentHolder = (ResourceHolder)this.closer.register(segment.getOrLoad());
            SegmentReference mappedSegment = this.mapSegment(((CompleteSegment)segmentHolder.get()).getSegment());
            CursorFactory cursorFactory = mappedSegment.asCursorFactory();
            if (cursorFactory == null) {
                throw new ISE("Null cursor factory found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
            }
            CursorHolder nextCursorHolder = cursorFactory.makeCursorHolder(ScanQueryEngine.makeCursorBuildSpec((ScanQuery)this.query.withQuerySegmentSpec((QuerySegmentSpec)new SpecificSegmentSpec((SegmentDescriptor)segment.getDescriptor())), null));
            try {
                nextCursor = nextCursorHolder.asCursor();
            }
            catch (Throwable t) {
                throw CloseableUtils.closeAndWrapInCatch((Throwable)t, (Closeable)nextCursorHolder);
            }
            if (nextCursor == null) {
                nextCursorHolder.close();
                return ReturnOrAwait.returnObject((Object)Unit.instance());
            }
            long rowsFlushed = this.setNextCursor(nextCursor, (Closeable)nextCursorHolder, ((CompleteSegment)segmentHolder.get()).getSegment());
            assert (rowsFlushed == 0L);
        }
        this.populateFrameWriterAndFlushIfNeededWithExceptionHandling();
        if (this.cursor.isDone()) {
            this.flushFrameWriter();
        }
        if (this.cursor.isDone() && (this.frameWriter == null || this.frameWriter.getNumRows() == 0)) {
            return ReturnOrAwait.returnObject((Object)Unit.instance());
        }
        return ReturnOrAwait.runAgain();
    }

    @Override
    protected ReturnOrAwait<Unit> runWithInputChannel(ReadableFrameChannel inputChannel, FrameReader inputFrameReader) throws IOException {
        if (this.cursor == null || this.cursor.isDone()) {
            if (inputChannel.canRead()) {
                Frame frame = inputChannel.read();
                FrameSegment frameSegment = new FrameSegment(frame, inputFrameReader, SegmentId.dummy((String)"scan"));
                SegmentReference mappedSegment = this.mapSegment((Segment)frameSegment);
                CursorFactory cursorFactory = mappedSegment.asCursorFactory();
                if (cursorFactory == null) {
                    throw new ISE("Null cursor factory found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
                }
                if (!Intervals.ONLY_ETERNITY.equals((Object)this.query.getIntervals())) {
                    throw DruidException.defensive((String)"Expected eternity intervals, but got[%s]", (Object[])new Object[]{this.query.getIntervals()});
                }
                CursorHolder nextCursorHolder = cursorFactory.makeCursorHolder(ScanQueryEngine.makeCursorBuildSpec((ScanQuery)this.query, null));
                Cursor nextCursor = nextCursorHolder.asCursor();
                if (nextCursor == null) {
                    nextCursorHolder.close();
                    return ReturnOrAwait.returnObject((Object)Unit.instance());
                }
                long rowsFlushed = this.setNextCursor(nextCursor, (Closeable)nextCursorHolder, (Segment)frameSegment);
                if (rowsFlushed > 0L) {
                    return ReturnOrAwait.runAgain();
                }
            } else {
                if (inputChannel.isFinished()) {
                    this.flushFrameWriter();
                    return ReturnOrAwait.returnObject((Object)Unit.instance());
                }
                return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
            }
        }
        this.populateFrameWriterAndFlushIfNeededWithExceptionHandling();
        if (this.cursor.isDone()) {
            return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
        }
        return ReturnOrAwait.runAgain();
    }

    private void populateFrameWriterAndFlushIfNeededWithExceptionHandling() {
        try {
            this.populateFrameWriterAndFlushIfNeeded();
        }
        catch (InvalidNullByteException inbe) {
            InvalidNullByteException.Builder builder = InvalidNullByteException.builder((InvalidNullByteException)inbe);
            throw builder.source(ParseExceptionUtils.generateReadableInputSourceNameFromMappedSegment(this.segment)).rowNumber(Integer.valueOf(this.cursorOffset.getOffset() + 1)).build();
        }
        catch (InvalidFieldException ffwe) {
            InvalidFieldException.Builder builder = InvalidFieldException.builder((InvalidFieldException)ffwe);
            throw builder.source(ParseExceptionUtils.generateReadableInputSourceNameFromMappedSegment(this.segment)).rowNumber(Integer.valueOf(this.cursorOffset.getOffset() + 1)).build();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void populateFrameWriterAndFlushIfNeeded() throws IOException {
        this.createFrameWriterIfNeeded();
        while (!this.cursor.isDone()) {
            if (!this.frameWriter.addSelection()) {
                if (this.frameWriter.getNumRows() > 0) {
                    long numRowsWritten = this.flushFrameWriter();
                    if (this.runningCountForLimit != null) {
                        this.runningCountForLimit.addAndGet(numRowsWritten);
                    }
                    return;
                }
                throw new FrameRowTooLargeException(this.currentAllocatorCapacity);
            }
            this.cursor.advance();
            this.cursorOffset.increment();
            this.partitionBoostVirtualColumn.setValue(this.partitionBoostVirtualColumn.getValue() + 1L);
        }
    }

    private void createFrameWriterIfNeeded() {
        if (this.frameWriter == null) {
            FrameWriterFactory frameWriterFactory = this.getFrameWriterFactory();
            ColumnSelectorFactory frameWriterColumnSelectorFactory = this.wrapColumnSelectorFactoryIfNeeded(this.frameWriterVirtualColumns.wrap(this.cursor.getColumnSelectorFactory()));
            this.frameWriter = frameWriterFactory.newFrameWriter(frameWriterColumnSelectorFactory);
            this.currentAllocatorCapacity = frameWriterFactory.allocatorCapacity();
        }
    }

    private long flushFrameWriter() throws IOException {
        if (this.frameWriter != null && this.frameWriter.getNumRows() > 0) {
            Frame frame = Frame.wrap((byte[])this.frameWriter.toByteArray());
            ((WritableFrameChannel)Iterables.getOnlyElement(this.outputChannels())).write(new FrameWithPartition(frame, -1));
            this.frameWriter.close();
            this.frameWriter = null;
            return frame.numRows();
        }
        if (this.frameWriter != null) {
            this.frameWriter.close();
            this.frameWriter = null;
        }
        return 0L;
    }

    private long setNextCursor(Cursor cursor, @Nullable Closeable cursorCloser, Segment segment) throws IOException {
        long rowsFlushed = this.flushFrameWriter();
        if (this.cursorCloser != null) {
            this.cursorCloser.close();
        }
        this.cursor = cursor;
        this.cursorCloser = cursorCloser;
        this.segment = segment;
        this.cursorOffset.reset();
        return rowsFlushed;
    }

    private ColumnSelectorFactory wrapColumnSelectorFactoryIfNeeded(ColumnSelectorFactory baseColumnSelectorFactory) {
        if (this.segment instanceof ExternalSegment) {
            return new ExternalColumnSelectorFactory(baseColumnSelectorFactory, ((ExternalSegment)this.segment).externalInputSource(), ((ExternalSegment)this.segment).signature(), this.cursorOffset);
        }
        return baseColumnSelectorFactory;
    }
}

