/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.shuffle.output;

import java.io.InputStream;
import java.util.List;
import org.apache.druid.error.DruidException;

public class ByteChunksInputStream
extends InputStream {
    private final List<byte[]> chunks;
    private int chunkNum;
    private int positionWithinChunk;

    public ByteChunksInputStream(List<byte[]> chunks, int positionWithinFirstChunk) {
        this.chunks = chunks;
        this.positionWithinChunk = positionWithinFirstChunk;
        this.chunkNum = -1;
        this.advanceChunk();
    }

    @Override
    public int read() {
        if (this.chunkNum >= this.chunks.size()) {
            return -1;
        }
        byte[] currentChunk = this.chunks.get(this.chunkNum);
        byte b = currentChunk[this.positionWithinChunk++];
        if (this.positionWithinChunk == currentChunk.length) {
            ++this.chunkNum;
            this.positionWithinChunk = 0;
        }
        return b & 0xFF;
    }

    @Override
    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (len == 0) {
            return 0;
        }
        if (this.chunkNum >= this.chunks.size()) {
            return -1;
        }
        int r = 0;
        while (r < len && this.chunkNum < this.chunks.size()) {
            byte[] currentChunk = this.chunks.get(this.chunkNum);
            int toReadFromCurrentChunk = Math.min(len - r, currentChunk.length - this.positionWithinChunk);
            System.arraycopy(currentChunk, this.positionWithinChunk, b, off + r, toReadFromCurrentChunk);
            r += toReadFromCurrentChunk;
            this.positionWithinChunk += toReadFromCurrentChunk;
            if (this.positionWithinChunk != currentChunk.length) continue;
            ++this.chunkNum;
            this.positionWithinChunk = 0;
        }
        return r;
    }

    @Override
    public void close() {
        this.chunkNum = this.chunks.size();
        this.positionWithinChunk = 0;
    }

    private void advanceChunk() {
        ++this.chunkNum;
        if (this.chunkNum < this.chunks.size() && this.chunks.get(this.chunkNum).length == 0) {
            throw DruidException.defensive((String)"Empty chunk not allowed", (Object[])new Object[0]);
        }
    }
}

