/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.azure;

import com.google.common.base.Predicate;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.druid.data.input.RetryingInputEntity;
import org.apache.druid.data.input.azure.AzureStorageAccountInputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.storage.azure.AzureByteSource;
import org.apache.druid.storage.azure.AzureByteSourceFactory;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureUtils;

public class AzureEntity
extends RetryingInputEntity {
    private final CloudObjectLocation location;
    private final AzureByteSource byteSource;
    private final String scheme;

    @AssistedInject
    AzureEntity(@Nonnull @Assisted CloudObjectLocation location, @Nonnull @Assisted AzureStorage azureStorage, @Nonnull @Assisted String scheme, @Nonnull AzureByteSourceFactory byteSourceFactory) {
        this.location = location;
        this.scheme = scheme;
        if ("azureStorage".equals(this.scheme)) {
            Pair<String, String> locationInfo = AzureStorageAccountInputSource.getContainerAndPathFromObjectLocation(location);
            this.byteSource = byteSourceFactory.create((String)locationInfo.lhs, (String)locationInfo.rhs, azureStorage);
        } else {
            this.byteSource = byteSourceFactory.create(location.getBucket(), location.getPath(), azureStorage);
        }
    }

    public URI getUri() {
        return this.location.toUri(this.scheme);
    }

    public Predicate<Throwable> getRetryCondition() {
        return AzureUtils.AZURE_RETRY;
    }

    protected InputStream readFrom(long offset) throws IOException {
        return this.byteSource.openStream(offset);
    }

    protected String getPath() {
        return this.location.getPath();
    }

    CloudObjectLocation getLocation() {
        return this.location;
    }
}

