/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl.systemfield;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.column.ColumnType;

public enum SystemField {
    URI("__file_uri", ColumnType.STRING),
    BUCKET("__file_bucket", ColumnType.STRING),
    PATH("__file_path", ColumnType.STRING);

    private final String fieldName;
    private final ColumnType columnType;

    private SystemField(String fieldName, ColumnType columnType) {
        this.fieldName = fieldName;
        this.columnType = columnType;
    }

    @JsonCreator
    public static SystemField fromFieldName(String fieldName) {
        for (SystemField field : SystemField.values()) {
            if (!field.getFieldName().equals(fieldName)) continue;
            return field;
        }
        throw new IAE("No such system field[%s]", fieldName);
    }

    @JsonValue
    public String getFieldName() {
        return this.fieldName;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public String toString() {
        return this.fieldName;
    }
}

