/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.ResourceLimitExceededException;

public class ByteTracker {
    private final long maxBytes;
    @GuardedBy(value="this")
    private long currentBytes;

    public ByteTracker(long maxBytes) {
        this.maxBytes = maxBytes;
    }

    public synchronized void reserve(long byteCount) throws ResourceLimitExceededException {
        Preconditions.checkState((byteCount >= 0L ? 1 : 0) != 0, (Object)"Can't reserve negative bytes");
        if (Math.addExact(this.currentBytes, byteCount) > this.maxBytes) {
            throw new ResourceLimitExceededException(StringUtils.format("Can't allocate any more bytes. maxBytes = %d, currentBytes = %d, requestedBytes = %d", this.maxBytes, this.currentBytes, byteCount));
        }
        this.currentBytes = Math.addExact(this.currentBytes, byteCount);
    }

    public synchronized void release(long byteCount) {
        Preconditions.checkState((byteCount >= 0L ? 1 : 0) != 0, (Object)"Can't release negative bytes");
        Preconditions.checkState((this.currentBytes >= byteCount ? 1 : 0) != 0, (Object)StringUtils.format("Can't release more than used bytes. currentBytes : %d, releasingBytes : %d", this.currentBytes, byteCount));
        this.currentBytes = Math.subtractExact(this.currentBytes, byteCount);
    }

    public static ByteTracker unboundedTracker() {
        return new ByteTracker(Long.MAX_VALUE);
    }
}

