/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import org.apache.datasketches.memory.WritableMemory;
import org.apache.druid.frame.field.NumericFieldWriter;
import org.apache.druid.frame.field.TransformUtils;
import org.apache.druid.segment.BaseLongColumnValueSelector;

public class LongFieldWriter
extends NumericFieldWriter {
    private final BaseLongColumnValueSelector selector;

    public static LongFieldWriter forPrimitive(BaseLongColumnValueSelector selector) {
        return new LongFieldWriter(selector, false);
    }

    static LongFieldWriter forArray(BaseLongColumnValueSelector selector) {
        return new LongFieldWriter(selector, true);
    }

    private LongFieldWriter(BaseLongColumnValueSelector selector, boolean forArray) {
        super(selector, forArray);
        this.selector = selector;
    }

    @Override
    public int getNumericSizeBytes() {
        return 8;
    }

    @Override
    public void writeSelectorToMemory(WritableMemory memory, long position) {
        this.writeToMemory(memory, position, this.selector.getLong());
    }

    @Override
    public void writeNullToMemory(WritableMemory memory, long position) {
        this.writeToMemory(memory, position, 0L);
    }

    private void writeToMemory(WritableMemory memory, long position, long value) {
        memory.putLong(position, TransformUtils.transformFromLong(value));
    }
}

