/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.key;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.druid.frame.key.ClusterByPartition;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.java.util.common.IAE;

public class ClusterByPartitions
implements Iterable<ClusterByPartition> {
    private static final ClusterByPartitions ONE_UNIVERSAL_PARTITION = new ClusterByPartitions(Collections.singletonList(new ClusterByPartition(null, null)));
    private final List<ClusterByPartition> ranges;

    @JsonCreator
    public ClusterByPartitions(List<ClusterByPartition> ranges) {
        if (ranges.isEmpty()) {
            throw new IAE("Must provide at least one range", new Object[0]);
        }
        this.ranges = ranges;
    }

    public static ClusterByPartitions oneUniversalPartition() {
        return ONE_UNIVERSAL_PARTITION;
    }

    public boolean allAbutting() {
        if (this.ranges.isEmpty()) {
            return true;
        }
        RowKey current = this.ranges.get(0).getEnd();
        for (int i = 1; i < this.ranges.size(); ++i) {
            if (current == null || !current.equals(this.ranges.get(i).getStart())) {
                return false;
            }
            current = this.ranges.get(i).getEnd();
        }
        return true;
    }

    public ClusterByPartition get(int i) {
        return this.ranges.get(i);
    }

    public int size() {
        return this.ranges.size();
    }

    @JsonValue
    public List<ClusterByPartition> ranges() {
        return this.ranges;
    }

    @Override
    public Iterator<ClusterByPartition> iterator() {
        return this.ranges.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterByPartitions that = (ClusterByPartitions)o;
        return Objects.equals(this.ranges, that.ranges);
    }

    public int hashCode() {
        return Objects.hash(this.ranges);
    }

    public String toString() {
        return "ClusterByPartitions{ranges=" + String.valueOf(this.ranges) + "}";
    }
}

