/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class SuperSorterProgressSnapshot {
    private final int totalMergingLevels;
    private final Map<Integer, Long> levelToTotalBatches;
    private final Map<Integer, Long> levelToMergedBatches;
    private final long totalMergersForUltimateLevel;
    private final boolean isTriviallyComplete;

    @JsonCreator
    public SuperSorterProgressSnapshot(@JsonProperty(value="totalMergingLevels") int totalMergingLevels, @JsonProperty(value="levelToTotalBatches") Map<Integer, Long> levelToTotalBatches, @JsonProperty(value="levelToMergedBatches") Map<Integer, Long> levelToMergedBatches, @JsonProperty(value="totalMergersForUltimateLevel") long totalMergersForUltimateLevel, @JsonProperty(value="triviallyComplete") boolean isTriviallyComplete) {
        this.totalMergingLevels = totalMergingLevels;
        this.levelToTotalBatches = levelToTotalBatches;
        this.levelToMergedBatches = levelToMergedBatches;
        this.totalMergersForUltimateLevel = totalMergersForUltimateLevel;
        this.isTriviallyComplete = isTriviallyComplete;
    }

    @JsonProperty(value="totalMergingLevels")
    public int getTotalMergingLevels() {
        return this.totalMergingLevels;
    }

    @JsonProperty(value="levelToTotalBatches")
    public Map<Integer, Long> getLevelToTotalBatches() {
        return this.levelToTotalBatches;
    }

    @JsonProperty(value="levelToMergedBatches")
    public Map<Integer, Long> getLevelToMergedBatches() {
        return this.levelToMergedBatches;
    }

    @JsonProperty(value="totalMergersForUltimateLevel")
    public long getTotalMergersForUltimateLevel() {
        return this.totalMergersForUltimateLevel;
    }

    @JsonProperty(value="triviallyComplete")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isTriviallyComplete() {
        return this.isTriviallyComplete;
    }

    @Nullable
    @JsonProperty(value="progressDigest")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Double getProgressDigest() {
        if (this.isTriviallyComplete) {
            return 1.0;
        }
        if (this.totalMergingLevels == -1) {
            return null;
        }
        double progress = 0.0;
        for (int level = 0; level < this.totalMergingLevels; ++level) {
            Long mergedBatches = this.levelToMergedBatches.getOrDefault(level, 0L);
            Long totalBatches = this.levelToTotalBatches.getOrDefault(level, -1L);
            if (mergedBatches == null || totalBatches == null || totalBatches <= 0L) continue;
            double levelProgress = mergedBatches.doubleValue() / totalBatches.doubleValue();
            progress += levelProgress / (double)this.totalMergingLevels;
        }
        return progress + 1.0E-6 > 1.0 ? 1.0 : progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuperSorterProgressSnapshot that = (SuperSorterProgressSnapshot)o;
        return this.totalMergingLevels == that.totalMergingLevels && this.totalMergersForUltimateLevel == that.totalMergersForUltimateLevel && this.isTriviallyComplete == that.isTriviallyComplete && Objects.equals(this.levelToTotalBatches, that.levelToTotalBatches) && Objects.equals(this.levelToMergedBatches, that.levelToMergedBatches);
    }

    public int hashCode() {
        return Objects.hash(this.totalMergingLevels, this.levelToTotalBatches, this.levelToMergedBatches, this.totalMergersForUltimateLevel, this.isTriviallyComplete);
    }
}

